/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mapi;

import com.atlassian.migration.agent.entity.MapiTaskMapping;
import com.atlassian.migration.agent.mapi.external.MapiMigrationService;
import com.atlassian.migration.agent.mapi.external.model.McsArtifactIdentifiers;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.mapi.external.model.UpdateArtifactRequest;
import com.atlassian.migration.agent.service.impl.MapiTaskMappingService;
import com.atlassian.migration.agent.service.prc.model.CommandName;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MapiArtifactService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapiArtifactService.class);
    private final MapiTaskMappingService mapiTaskMappingService;
    private final MapiMigrationService mapiMigrationService;

    public void updateArtifactsToMapi(String planId, String migrationId, String cloudId, String fileName, String fileId) {
        Optional<MapiTaskMapping> mapiJobDetailsForPlan = this.getMapiJobDetailsForPlan(planId);
        if (mapiJobDetailsForPlan.isPresent()) {
            MapiTaskMapping mapiTaskMapping = mapiJobDetailsForPlan.get();
            log.debug("Found Migration with PlanId {} for Mapi with JobId {} and TaskId {}", new Object[]{planId, mapiTaskMapping.getJobId(), mapiTaskMapping.getTaskId()});
            try {
                McsArtifactIdentifiers artifactIdentifiers = new McsArtifactIdentifiers(migrationId, fileId);
                UpdateArtifactRequest request = new UpdateArtifactRequest(fileName, artifactIdentifiers);
                this.mapiMigrationService.sendArtifactsToMapi(mapiTaskMapping.getJobId(), mapiTaskMapping.getTaskId(), cloudId, request);
                log.debug("Pushed the error log artifact to Mapi");
            }
            catch (PublicApiException.CloudIdDoesNotExist e) {
                log.error("ClouldId" + cloudId + " is not present. Not able to upload the error logs to MAPI service", (Throwable)e);
            }
        }
    }

    private Optional<MapiTaskMapping> getMapiJobDetailsForPlan(String planId) {
        return this.mapiTaskMappingService.getTaskMapping(planId, Optional.empty(), Optional.of(ImmutableList.of((Object)CommandName.MIGRATE.getName())));
    }

    @Generated
    public MapiArtifactService(MapiTaskMappingService mapiTaskMappingService, MapiMigrationService mapiMigrationService) {
        this.mapiTaskMappingService = mapiTaskMappingService;
        this.mapiMigrationService = mapiMigrationService;
    }
}

