/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUsersMigrationExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.SpaceExportProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class SpaceExportWorker
extends V4Worker<SpaceExportTransferTask> {
    @Autowired
    private final SpaceExportExecutor spaceExportExecutor;
    @Autowired
    private final SpaceUsersMigrationExecutor spaceUsersMigrationExecutor;
    @Autowired
    private final SpaceManager spaceManager;
    @Autowired
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public SpaceExportWorker(List<ProgressUnit> supportedUnits, SpaceExportExecutor spaceExportExecutor, SpaceManager spaceManager, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, SpaceUsersMigrationExecutor spaceUsersMigrationExecutor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationLogService migrationLogService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.spaceExportExecutor = spaceExportExecutor;
        this.spaceManager = spaceManager;
        this.spaceUsersMigrationExecutor = spaceUsersMigrationExecutor;
        this.commandName = CommandName.CONFLUENCE_SPACE_EXPORT;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @Override
    public void process(PrcTask<SpaceExportTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        this.updatePrcStep(prcStep);
        SpaceExportProcessor processor = new SpaceExportProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.spaceExportExecutor, this.spaceUsersMigrationExecutor, this.migrationDarkFeaturesManager, this.getPtx(), this.getStepStore(), this.migrationLogService);
        processor.initiate();
    }

    private void updatePrcStep(Step prcStep) {
        prcStep.setType(StepType.CONFLUENCE_EXPORT.name());
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<SpaceExportTransferTask> prcTask) {
        String spaceKey = Objects.requireNonNull(this.spaceManager.getSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId()))).getKey();
        return tasks.stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        String cloudId = task.getPlan().getCloudSite().getCloudId();
        step.setConfig(Jsons.valueAsString(new ConfExportStepConfig(task.getSpaceKey(), cloudId)));
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_SPACE_EXPORT;
    }
}

