/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTerminator {
    private final Logger log = LoggerFactory.getLogger(MigrationTerminator.class);
    private final PluginTransactionTemplate ptx;
    private final PlanStore planStore;

    public MigrationTerminator(PlanStore planStore, PluginTransactionTemplate ptx) {
        this.planStore = planStore;
        this.ptx = ptx;
    }

    public void terminateMigration(String planId, Optional<Plan> optionalPlan, String message) {
        this.ptx.write(() -> {
            Plan plan = optionalPlan.orElse(this.planStore.getPlan(planId));
            List<Task> tasks = plan.getTasks();
            tasks.forEach(task -> {
                if (task.getProgress().getStatus() != ExecutionStatus.DONE) {
                    task.setProgress(task.getProgress().copy().failed(message));
                }
            });
            plan.setTasks(tasks);
            plan.setProgress(plan.getProgress().copy().failed(message));
            this.planStore.updatePlan(plan);
        });
    }
}

