/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.util;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.MigrateGlobalEntitiesTask;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import com.atlassian.migration.agent.service.catalogue.model.SiteContainer;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationCreationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationCreationHelper.class);
    private final PlatformService platformService;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final PluginTransactionTemplate ptx;
    private final TaskStore taskStore;

    public MigrationCreationHelper(PlatformService platformService, MigrationDarkFeaturesManager darkFeaturesManager, PluginTransactionTemplate ptx, TaskStore taskStore) {
        this.platformService = platformService;
        this.darkFeaturesManager = darkFeaturesManager;
        this.ptx = ptx;
        this.taskStore = taskStore;
    }

    public MigrationDetails retrieveMigrationDetails(Plan plan) {
        String cloudId = plan.getCloudSite().getCloudId();
        return this.platformService.createMigrationInMcs(cloudId, plan);
    }

    public void createContainersInMcs(String cloudId, String migrationId, Plan plan) {
        try {
            boolean createAppContainersForAllListeners = this.darkFeaturesManager.appMigrationDevMode();
            this.platformService.createContainersInMcs(cloudId, migrationId, plan);
            this.platformService.createAppContainers(cloudId, migrationId, plan.getTasks(), createAppContainersForAllListeners);
            this.updateUserAndGlobalTemplatesTaskWithContainerId(plan);
            this.updateSpaceTaskWithContainerId(plan);
        }
        catch (Exception e) {
            log.error("Failed to create containers in mcs, cloudId: {}", (Object)cloudId, (Object)e);
        }
    }

    private void updateUserAndGlobalTemplatesTaskWithContainerId(Plan plan) {
        try {
            Optional<MigrateUsersTask> usersTask = plan.getUserTaskOfPlan();
            Optional<MigrateGlobalEntitiesTask> globalEntitiesTask = plan.getGlobalEntitiesTaskOfPlan();
            Set<SiteContainer> containers = this.platformService.getSiteContainers(plan);
            containers.forEach(container -> {
                if (usersTask.isPresent() && container.getSelections().contains((Object)SiteContainer.SiteSelection.USERS)) {
                    ((MigrateUsersTask)usersTask.get()).setContainerId(container.getContainerId());
                    this.ptx.write(() -> this.taskStore.update((Task)usersTask.get()));
                }
                if (globalEntitiesTask.isPresent() && container.getSelections().contains((Object)SiteContainer.SiteSelection.GLOBAL_ENTITIES)) {
                    ((MigrateGlobalEntitiesTask)globalEntitiesTask.get()).setContainerId(container.getContainerId());
                    this.ptx.write(() -> this.taskStore.update((Task)globalEntitiesTask.get()));
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to update user task with containerId for planId: {}", (Object)plan.getId(), (Object)e);
        }
    }

    private void updateSpaceTaskWithContainerId(Plan plan) {
        try {
            Set<ConfluenceSpaceContainer> containers = this.platformService.getConfluenceSpaceContainers(plan);
            HashMap spaceKeyToContainerId = new HashMap();
            containers.forEach(container -> spaceKeyToContainerId.put(container.getKey(), container.getContainerId()));
            ArrayList spaceTasks = new ArrayList();
            plan.getTasks().forEach(t -> {
                if (t.getType().equals((Object)TaskType.SPACE) || t.getType().equals((Object)TaskType.ATTACHMENTS)) {
                    spaceTasks.add((AbstractSpaceTask)t);
                }
            });
            this.ptx.write(() -> spaceTasks.forEach(task -> {
                task.setContainerId((String)spaceKeyToContainerId.get(task.getSpaceKey()));
                this.taskStore.update((Task)task);
            }));
        }
        catch (Exception e) {
            log.error("Failed to update space task with containerId for planId: {}", (Object)plan.getId(), (Object)e);
        }
    }
}

