/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.user.UsersMigrationExecutor;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.request.v2.MigrationGroupV2Dto;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import java.util.ArrayList;
import java.util.Collections;

public class UsersMigrationShadowExecutor
extends ShadowMigrationExecutor {
    private final ProgressTracker progressTracker;

    public UsersMigrationShadowExecutor(StepStore stepStore, ProgressTracker progressTracker) {
        super(stepStore);
        this.progressTracker = progressTracker;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        Step originalStep = this.getOriginalStep(prcTask, StepType.USERS_MIGRATION);
        this.sendProgressUpdate(prcTask);
        this.sendCompletionStatus(prcTask, originalStep);
        return StepResult.succeeded("Exported & Uploaded Users And Groups for shadow migration");
    }

    private void sendProgressUpdate(PrcTask prcTask) {
        this.progressTracker.sendV4ProgressUpdates(Collections.emptyMap(), StepSubType.USERS_UPLOAD.getDetailedStatus(), prcTask, 100, "Successfully uploaded users and groups for shadow migration");
    }

    private void sendCompletionStatus(PrcTask prcTask, Step originalStep) {
        UsersMigrationExecutor.UsersMigrationExecutorJobMetadata jobMetadata = Jsons.readValue(originalStep.getExecutionState(), UsersMigrationExecutor.UsersMigrationExecutorJobMetadata.class);
        this.progressTracker.sendV4UserCompletionStatus(new UsersMigrationV2FilePayload(new ArrayList<MigrationUserDto>(jobMetadata.getRequestMetadata().getUserCount()), new ArrayList<MigrationGroupV2Dto>(jobMetadata.getRequestMetadata().getGroupCount()), Collections.emptyMap()), jobMetadata.getRequestMetadata().getFileId(), prcTask, "Successfully uploaded users and groups for shadow migration");
    }
}

