/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.service.guardrails.macro.AbstractDatabaseMacroAssessmentSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import org.jetbrains.annotations.NotNull;

public class ContentPropertyMacroAssessmentSupplier
extends AbstractDatabaseMacroAssessmentSupplier {
    public ContentPropertyMacroAssessmentSupplier(EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        super(tmpl, bootstrapManager);
    }

    @Override
    String getQuery() {
        String emptyString = this.getEmptyString();
        return "select cp.content.id as id, cp.stringval as macros, c.spaceId as spaceId, cc.spaceId as commentSpaceId, c.container.id as pageId, c.type from ContentProperty cp join Content c on c.id = cp.content.id left join Content cc ON cc.id = c.container.id where c.previousVersion is null and cp.name = 'macroNames' and cp.stringval is not null and (cc.type = 'COMMENT' or c.type in ('BLOGPOST', 'PAGE')) and cp.stringval <> " + emptyString;
    }

    @NotNull
    private String getEmptyString() {
        ApplicationConfiguration applicationConfig = this.bootstrapManager.getApplicationConfig();
        String dialect = (String)applicationConfig.getProperty((Object)"hibernate.dialect");
        return dialect.toLowerCase().contains("oracle") ? "' '" : "''";
    }

    @Override
    Stream<MacroTuple> map(Tuple tuple) {
        Long contentId = (Long)tuple.get(0, Long.class);
        String stringProps = (String)tuple.get(1, String.class);
        Long spaceId = (Long)tuple.get(2, Long.class);
        Long commentSpaceId = (Long)tuple.get(3, Long.class);
        Long pageId = (Long)tuple.get(4, Long.class);
        String contentType = (String)tuple.get(5, String.class);
        return ContentPropertyMacroAssessmentSupplier.createResultSet(stringProps, contentId, spaceId, pageId, commentSpaceId, contentType);
    }

    @Override
    String getMacroAssessmentName() {
        return "Content property macro assessment";
    }

    @NotNull
    private static Stream<MacroTuple> createResultSet(String stringProps, Long contentId, Long spaceId, Long pageId, Long commentSpaceId, String contentType) {
        return Arrays.stream(stringProps.split(",")).map((? super T macro) -> new MacroTuple(contentId, spaceId != null ? spaceId : commentSpaceId, pageId, (String)macro, contentType));
    }
}

