/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.migration.agent.mapi.entity.MapiStatusDto;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.check.csv.AbstractCheckResultCSVBean;
import com.atlassian.migration.agent.service.check.csv.AppVendorCheckCSVContainer;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedChecksFileReportsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailedChecksFileReportsManager.class);
    public final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final PreflightService preflightService;
    private final CheckResultFileManager checkResultFileManager;

    public FailedChecksFileReportsManager(PreflightService preflightService, CheckResultFileManager checkResultFileManager) {
        this.preflightService = preflightService;
        this.checkResultFileManager = checkResultFileManager;
    }

    public File createCSVFileForFailedCheck(String executionId, CheckType checkType) {
        if (CheckType.checkTypesForCSV.contains(checkType)) {
            return this.createCheckResultCSVFile(executionId, checkType);
        }
        if (CheckType.APP_VENDOR_CHECK.equals(checkType)) {
            return this.createAppVendorCheckCSVFile(executionId, checkType);
        }
        return null;
    }

    private File createCheckResultCSVFile(String executionId, CheckType checkType) {
        CheckResultCSVContainer checkResultCSVContainer = this.preflightService.createCheckResultCSVContainer(executionId, checkType);
        String filename = this.generateSimpleFilename(checkType);
        return this.saveCheckResultToFile(filename, checkResultCSVContainer, executionId, checkType);
    }

    private File createAppVendorCheckCSVFile(String executionId, CheckType checkType) {
        Optional<AppVendorCheckCSVContainer> appVendorCheckResultCSVContainer = this.preflightService.createAppVendorCheckResultCSVContainer(executionId, "", "");
        return appVendorCheckResultCSVContainer.map(container -> this.saveAppVendorCheckResultToFile(this.generateSimpleFilename(checkType), (AppVendorCheckCSVContainer)container, executionId, checkType)).orElse(null);
    }

    public CheckType getCheckType(MapiStatusDto mapiStatusDto) {
        for (String level : mapiStatusDto.getLevel()) {
            CheckType checkType = CheckType.fromString(level);
            if (checkType == CheckType.UNKNOWN_CHECK_TYPE) continue;
            return checkType;
        }
        return CheckType.UNKNOWN_CHECK_TYPE;
    }

    private File saveCheckResultToFile(String filename, CheckResultCSVContainer<AbstractCheckResultCSVBean> checkResultCSVContainer, String executionId, CheckType checkType) {
        return this.saveToFileWithLogging(() -> this.checkResultFileManager.saveToFileInCSVFormat(filename, checkResultCSVContainer), executionId, checkType);
    }

    private File saveAppVendorCheckResultToFile(String filename, AppVendorCheckCSVContainer appVendorCheckCSVContainer, String executionId, CheckType checkType) {
        return this.saveToFileWithLogging(() -> this.checkResultFileManager.saveToFileInCSVFormat(filename, appVendorCheckCSVContainer), executionId, checkType);
    }

    private File saveToFileWithLogging(Supplier<File> saveOperation, String executionId, CheckType checkType) {
        try {
            return saveOperation.get();
        }
        catch (RuntimeException ex) {
            String errorMessage = String.format("Failed to save failed check result details to file for executionId = %s and checkType = %s", executionId, checkType);
            log.error(errorMessage, (Throwable)ex);
            throw new RuntimeException(errorMessage, ex);
        }
    }

    public void deleteTemporaryFile(File file) {
        if (file != null && file.exists()) {
            this.checkResultFileManager.deleteFile(file.getName());
        }
    }

    public String generateSimpleFilename(CheckType checkType) {
        return checkType.value() + "_" + this.dateFormat.format(new Date(Instant.now().toEpochMilli())) + ".csv";
    }

    public String generateFilename(String name, CheckType checkType) {
        String fileNameSubstring = this.getFileNameSubstring(checkType);
        return name + fileNameSubstring + checkType.value() + "_Confluence_" + this.dateFormat.format(new Date(Instant.now().toEpochMilli())) + ".csv";
    }

    @NotNull
    private String getFileNameSubstring(CheckType checkType) {
        String fileNameSubstring = "_Pre-migration_checks_Spaces_";
        if (checkType.equals(CheckType.GLOBAL_DATA_TEMPLATE)) {
            fileNameSubstring = "_Pre-migration_checks_Global_Templates_";
        }
        return fileNameSubstring;
    }

    public String generateAppVendorCSVFilename(String executionId, String appKey, String checkId) {
        return executionId + "-AppVendorCheck-" + appKey + "-" + checkId + ".csv";
    }
}

