/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.InstanceInfoDto;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.license.LicenseHandler;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="instance")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
public class InstanceInfoResource {
    private final SENSupplier senSupplier;
    private final LicenseHandler licenseHandler;

    @Inject
    public InstanceInfoResource(SENSupplier senSupplier, LicenseHandler licenseHandler) {
        this.senSupplier = senSupplier;
        this.licenseHandler = licenseHandler;
    }

    @GET
    @Path(value="/info")
    public Response getServerInstanceInfo() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return Response.ok((Object)new InstanceInfoDto(user.getEmail(), user.getName(), this.senSupplier.get(), this.licenseHandler.getServerId())).build();
    }
}

