/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.queries.membership.DirectoryData;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipDataAccessor;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipEntityCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.RawMembershipCounts;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Tuple;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class MembershipFetcher {
    private static final Logger log = ContextLoggerFactory.getLogger(MembershipFetcher.class);
    private final DirectoryManager directoryManager;
    private final MembershipDataAccessor accessor;

    public MembershipFetcher(DirectoryManager directoryManager, MembershipDataAccessor accessor) {
        this.directoryManager = directoryManager;
        this.accessor = accessor;
    }

    public MembershipCounts processDirectories() {
        RawMembershipCounts users = null;
        RawMembershipCounts groups = null;
        for (Directory dir : this.directoryManager.findAllDirectories()) {
            if (!dir.isActive()) continue;
            try {
                boolean nested = this.directoryManager.supportsNestedGroups(dir.getId().longValue());
                DirectoryData data = nested ? this.processNested(dir.getId()) : this.processFlat(dir.getId());
                log.info("DirectoryData for directoryId {} is {}", (Object)dir.getId(), (Object)data);
                users = users == null ? data.users : users.append(data.users);
                groups = groups == null ? data.groups : groups.append(data.groups);
            }
            catch (DirectoryInstantiationException | DirectoryNotFoundException e) {
                log.warn("Exception when checking directory nested group support", e);
            }
        }
        if (users == null || groups == null) {
            return null;
        }
        return new MembershipCounts(new MembershipEntityCounts(users.ids, users.counts), new MembershipEntityCounts(groups.ids, groups.counts));
    }

    private DirectoryData processFlat(long directoryId) {
        return new DirectoryData(null, RawMembershipCounts.fromFlatCounts(this.accessor.listUserParentsCountFlat(directoryId)), RawMembershipCounts.fromFlatCounts(this.accessor.listGroupUsersCountsFlat(directoryId)));
    }

    private DirectoryData processNested(long directoryId) {
        int batchSize = 1000;
        RawMembershipCounts groups = RawMembershipCounts.fromIds(this.accessor.listGroups(directoryId));
        int[][] groupParents = MembershipFetcher.buildParents(MembershipFetcher.toSortedArrayOfTuples(this.accessor.listGroupParents(directoryId)), groups);
        RawMembershipCounts users = RawMembershipCounts.fromIds(this.accessor.listActiveUsers(directoryId));
        DirectoryData data = new DirectoryData(groupParents, users, groups);
        for (int i = 0; i < users.ids.length; i += batchSize) {
            long min = users.ids[i];
            long max = users.ids[Math.min(users.ids.length, i + batchSize) - 1];
            data.addUserGroups(MembershipFetcher.toSortedArrayOfTuples(this.accessor.listUserParents(directoryId, min, max)));
        }
        return data;
    }

    private static long[][] toSortedArrayOfTuples(List<Tuple> data) {
        long[][] array = new long[data.size()][2];
        for (int i = 0; i < array.length; ++i) {
            Tuple tuple = data.get(i);
            long[] entry = array[i];
            entry[0] = (Long)tuple.get(0, Long.class);
            entry[1] = (Long)tuple.get(1, Long.class);
        }
        Arrays.sort(array, Comparator.comparing(a -> a[0]));
        return array;
    }

    private static int[][] buildParents(long[][] childToParent, RawMembershipCounts groups) {
        int[][] res = new int[groups.ids.length][];
        int i = 0;
        while (i < childToParent.length) {
            int next2 = MembershipFetcher.getNext(childToParent, i);
            int childIdx = groups.getIndex(childToParent[i][0]);
            if (childIdx >= 0) {
                res[childIdx] = MembershipFetcher.extract(childToParent, i, next2, groups);
            }
            i = next2;
        }
        for (i = 0; i < res.length; ++i) {
            if (res[i] != null) continue;
            res[i] = ArrayUtils.EMPTY_INT_ARRAY;
        }
        return res;
    }

    static int[] extract(long[][] childToParent, int start, int end, RawMembershipCounts parents) {
        int[] res = new int[end - start];
        int len = 0;
        for (int i = start; i < end; ++i) {
            int parentIdx = parents.getIndex(childToParent[i][1]);
            if (parentIdx < 0) continue;
            res[len++] = parentIdx;
        }
        return len == res.length ? res : Arrays.copyOf(res, len);
    }

    static int getNext(long[][] arr, int start) {
        int end;
        long val = arr[start][0];
        for (end = start + 1; end < arr.length && arr[end][0] == val; ++end) {
        }
        return end;
    }
}

