/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.guardrails.results.NumberOfMacrosPerPageQueryResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.Page;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Tuple;
import org.slf4j.Logger;

public class NumberOfMacrosPerPageQuery
extends AbstractQuery<NumberOfMacrosPerPageQueryResult> {
    private static final Logger log = ContextLoggerFactory.getLogger(NumberOfMacrosPerPageQuery.class);
    private static final int PAGE_SIZE = 5000;

    public NumberOfMacrosPerPageQuery(EntityManagerTemplate tmpl) {
        super(QueryIds.NUMBER_OF_MACROS_PER_PAGE, tmpl, "select cp.content.id as page_id, cp.name as content_property_name, cp.stringval as content_property_value from ContentProperty cp where (cp.name like 'macro-count.style%' or cp.name like 'macro-count.gadget%' or cp.name like 'macro-count.multimedia%' or cp.name like 'macro-count.spaces%' or cp.name like 'macro-count.unmigrated-wiki-markup%' or cp.name like 'macro-count.portfolioforjiraplan%') and (cp.stringval is not null or cp.stringval <> '') and cp.content.id in (select content.id from Content content where content.type in ('PAGE', 'BLOGPOST') and content.status in ('current', 'draft') and content.previousVersion is null) order by cp.content.id", new NumberOfMacrosPerPageQueryResult((Map<Long, Integer>)ImmutableMap.of((Object)136020515L, (Object)20, (Object)54689987L, (Object)10, (Object)36864077L, (Object)3)));
    }

    @Override
    public NumberOfMacrosPerPageQueryResult execute() {
        log.info("Starting to retrieve the number of macros per page data...");
        long startTime = System.currentTimeMillis();
        Map<Long, Integer> counts = this.countMacros();
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        log.info("Got all number of macros per page {}", (Object)duration);
        return new NumberOfMacrosPerPageQueryResult(counts);
    }

    private Map<Long, Integer> countMacros() {
        HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
        Page<Tuple> page = this.prepareQuery(Tuple.class).page(5000);
        while (page.hasContent()) {
            for (Tuple tuple : page.getContent()) {
                counts.merge((Long)tuple.get(0, Long.class), GuardrailsUtil.getMacrosCount((String)tuple.get(2, String.class)), Integer::sum);
            }
            page = page.next();
        }
        return counts;
    }
}

