/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.scan;

import com.atlassian.migration.agent.store.UserBaseScanStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.udc.utils.UDCMapperUtils;
import com.atlassian.migration.udc.common.model.user.User;
import com.atlassian.migration.udc.common.model.userbasescan.ScanStatus;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import com.atlassian.migration.udc.scan.UserBaseScanRepository;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCMAUserBaseScanRepository
implements UserBaseScanRepository {
    private final UserBaseScanStore userBaseScanStore;
    private final PluginTransactionTemplate ptx;

    @Nullable
    public UserBaseScan getLatestStarted() {
        return this.userBaseScanStore.getLatestStarted().map(UDCMapperUtils::toUDC).orElse(null);
    }

    @Nullable
    public UserBaseScan getScan(@NotNull String scanId) {
        Optional<UserBaseScan> scan = this.userBaseScanStore.get(scanId).map(UDCMapperUtils::toUDC);
        return scan.orElse(null);
    }

    @NotNull
    public UserBaseScan insert(@NotNull UserBaseScan userBaseScan, @NotNull User user) {
        this.ptx.write(() -> this.userBaseScanStore.save(UDCMapperUtils.fromUDC(userBaseScan)));
        return userBaseScan;
    }

    public void updateStatus(@NotNull String scanId, @NotNull ScanStatus scanStatus, @NotNull User user) {
        this.ptx.write(() -> this.userBaseScanStore.updateStatus(scanId, scanStatus));
    }

    @NotNull
    public UserBaseScan updateStatusAndCounts(@NotNull UserBaseScan userBaseScan, @NotNull User user) {
        this.ptx.write(() -> this.userBaseScanStore.updateStatusAndCounts(userBaseScan.getId(), userBaseScan.getStatus(), userBaseScan.getInvalidUsersCount(), userBaseScan.getDuplicatedUsersCount()));
        return userBaseScan;
    }

    @Generated
    public CCMAUserBaseScanRepository(UserBaseScanStore userBaseScanStore, PluginTransactionTemplate ptx) {
        this.userBaseScanStore = userBaseScanStore;
        this.ptx = ptx;
    }
}

