/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.persistence.Tuple;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

class RawMembershipCounts {
    long[] ids;
    long[] counts;

    int getIndex(long id) {
        return Arrays.binarySearch(this.ids, id);
    }

    public String toString() {
        return LongStream.of(this.counts).boxed().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).map(e -> e.getKey() + "(" + e.getValue() + ")").collect(Collectors.joining(", "));
    }

    static RawMembershipCounts fromIds(List<Long> data) {
        long[] ids = new long[data.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = data.get(i);
        }
        Arrays.sort(ids);
        return new RawMembershipCounts(ids, new long[ids.length]);
    }

    static RawMembershipCounts fromFlatCounts(List<Tuple> data) {
        long[] ids = new long[data.size()];
        long[] counts = new long[data.size()];
        for (int i = 0; i < ids.length; ++i) {
            Tuple tuple = data.get(i);
            ids[i] = (Long)tuple.get(0, Long.class);
            counts[i] = ((Long)tuple.get(1, Long.class)).intValue();
        }
        return new RawMembershipCounts(ids, counts);
    }

    public RawMembershipCounts append(RawMembershipCounts counts) {
        return new RawMembershipCounts(ArrayUtils.addAll((long[])this.ids, (long[])counts.ids), ArrayUtils.addAll((long[])this.counts, (long[])counts.counts));
    }

    @Generated
    public long[] getIds() {
        return this.ids;
    }

    @Generated
    public long[] getCounts() {
        return this.counts;
    }

    @Generated
    public void setIds(long[] ids) {
        this.ids = ids;
    }

    @Generated
    public void setCounts(long[] counts) {
        this.counts = counts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawMembershipCounts)) {
            return false;
        }
        RawMembershipCounts other = (RawMembershipCounts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getIds(), other.getIds())) {
            return false;
        }
        return Arrays.equals(this.getCounts(), other.getCounts());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawMembershipCounts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getIds());
        result = result * 59 + Arrays.hashCode(this.getCounts());
        return result;
    }

    @Generated
    public RawMembershipCounts(long[] ids, long[] counts) {
        this.ids = ids;
        this.counts = counts;
    }
}

