/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipDataAccessor;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.List;
import javax.persistence.Tuple;

public class DbMembershipDataAccessor
implements MembershipDataAccessor {
    private final EntityManagerTemplate tmpl;

    public DbMembershipDataAccessor(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public List<Long> listGroups(long directoryId) {
        return this.tmpl.query(Long.class, "select g.id from CrowdGroup g where g.crowdDirectory.id = :directoryId").param("directoryId", (Object)directoryId).list();
    }

    @Override
    public List<Long> listActiveUsers(long directoryId) {
        return this.tmpl.query(Long.class, "select u.id from CrowdUser u where u.crowdDirectory.id = :directoryId and u.active = :active").param("directoryId", (Object)directoryId).param("active", (Object)true).list();
    }

    @Override
    public List<Tuple> listGroupParents(long directoryId) {
        return this.tmpl.query(Tuple.class, "select cm.childGroup, cm.parent from CrowdMembership cm join CrowdGroup cg on cg.id=cm.childGroup where cg.crowdDirectory.id = :directoryId ").param("directoryId", (Object)directoryId).list();
    }

    @Override
    public List<Tuple> listUserParents(long directoryId, long minId, long maxId) {
        return this.tmpl.query(Tuple.class, "select cm.child, cm.parent from CrowdMembership cm join CrowdGroup cg on cg.id=cm.parent where cg.crowdDirectory.id = :directoryId and cm.child between :minId and :maxId").param("directoryId", (Object)directoryId).param("minId", (Object)minId).param("maxId", (Object)maxId).list();
    }

    @Override
    public List<Tuple> listGroupUsersCountsFlat(long directoryId) {
        return this.listFlat(directoryId, "cm.parent");
    }

    @Override
    public List<Tuple> listUserParentsCountFlat(long directoryId) {
        return this.listFlat(directoryId, "cm.child");
    }

    private List<Tuple> listFlat(long directoryId, String groupBy) {
        return this.tmpl.query(Tuple.class, "select " + groupBy + ", count(*) as cnt from CrowdMembership cm join CrowdGroup cg on cg.id=cm.parent where cg.crowdDirectory.id = :directoryId and cm.child is not null group by " + groupBy).param("directoryId", (Object)directoryId).list();
    }
}

