/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import oshi.SystemInfo;

public class CpuStatsCalculator {
    private static final int INITIAL_MEASUREMENT_DURATION = 1000;
    private final double initialLoad = CpuStatsCalculator.measureCpuLoad(1000L);
    private long[][] startTicks = null;
    private long statTime = 0L;
    private final Clock clock;
    private static final Logger log = ContextLoggerFactory.getLogger(CpuStatsCalculator.class);

    public static CpuStatsCalculator createCalculator() {
        return new CpuStatsCalculator(Clock.systemDefaultZone());
    }

    public static CpuStatsCalculator createCalculator(Clock clock) {
        return new CpuStatsCalculator(clock);
    }

    public void start() {
        this.startTicks = CpuStatsCalculator.getCpuTicks();
        this.statTime = this.clock.millis();
    }

    public CpuStats finish() {
        return new CpuStats(CpuStatsCalculator.getCpuLoad(this.startTicks, this.initialLoad), this.duration());
    }

    public Duration duration() {
        return Duration.ofMillis(this.clock.millis() - this.statTime);
    }

    private static double getCpuLoad(long[][] oldCpuTicks, double cpuLoadBeforeAssessment) {
        double[] cpuLoad = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadBetweenTicks(oldCpuTicks);
        double queryCpuLoad = Arrays.stream(cpuLoad).summaryStatistics().getAverage();
        double diffLoad = cpuLoadBeforeAssessment - queryCpuLoad;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        DecimalFormat df = new DecimalFormat("#.00", symbols);
        log.debug("CPU load result without formatting: {}", (Object)diffLoad);
        double result = diffLoad;
        try {
            String formattedResult = df.format(diffLoad);
            Number parsedResult = df.parse(formattedResult);
            log.debug("CPU load result after formatting: {}", (Object)parsedResult);
            result = parsedResult.doubleValue();
        }
        catch (ParseException e) {
            log.error("Error parsing CPU load result", (Throwable)e);
        }
        return result;
    }

    private static double measureCpuLoad(long measurementTime) {
        double[] cpuLoad = new SystemInfo().getHardware().getProcessor().getProcessorCpuLoad(measurementTime);
        return Arrays.stream(cpuLoad).summaryStatistics().getAverage();
    }

    private static long[][] getCpuTicks() {
        return new SystemInfo().getHardware().getProcessor().getProcessorCpuLoadTicks();
    }

    @Generated
    public CpuStatsCalculator(Clock clock) {
        this.clock = clock;
    }

    public static class CpuStats {
        double load;
        Duration duration;

        @Generated
        public double getLoad() {
            return this.load;
        }

        @Generated
        public Duration getDuration() {
            return this.duration;
        }

        @Generated
        public void setLoad(double load) {
            this.load = load;
        }

        @Generated
        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuStats)) {
                return false;
            }
            CpuStats other = (CpuStats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLoad(), other.getLoad()) != 0) {
                return false;
            }
            Duration this$duration = this.getDuration();
            Duration other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CpuStats;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $load = Double.doubleToLongBits(this.getLoad());
            result = result * 59 + (int)($load >>> 32 ^ $load);
            Duration $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CpuStatsCalculator.CpuStats(load=" + this.getLoad() + ", duration=" + this.getDuration() + ")";
        }

        @Generated
        public CpuStats(double load, Duration duration) {
            this.load = load;
            this.duration = duration;
        }
    }
}

