/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.mapi.entity.AttachCloudError;
import com.atlassian.migration.agent.mapi.entity.AttachCloudResponse;
import com.atlassian.migration.agent.mapi.executor.CloudExecutorService;
import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.service.prc.PrcClientService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.time.Instant;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="public")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MapiResource {
    private CloudExecutorService cloudExecutorService;
    private PrcClientService prcClientService;
    private final Supplier<Instant> instantSupplier;

    @Inject
    public MapiResource(CloudExecutorService cloudExecutorService, PrcClientService prcClientService) {
        this.cloudExecutorService = cloudExecutorService;
        this.prcClientService = prcClientService;
        this.instantSupplier = Instant::now;
    }

    @POST
    @Path(value="/v1/attach")
    public Response attachCloudUrl(@QueryParam(value="cloudUrl") String cloudUrl) {
        try {
            Instant pollerExpiryTime = this.prcClientService.attach(cloudUrl);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new AttachCloudResponse(cloudUrl, pollerExpiryTime)).build();
        }
        catch (PublicApiException.CloudUrlDoesNotExist ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new AttachCloudError("Invalid Request. Reason = " + ex.getMessage())).build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new AttachCloudError("Please check Confluence Logs to find the issue or contact support, if the issue persists.")).build();
        }
    }
}

