/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.globalentities.V4GlobalEntitiesUploadExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class GlobalEntitiesUploadProcessor
extends AbstractProcessor<GlobalEntitiesTransferTask> {
    private final V4GlobalEntitiesUploadExecutor v4GlobalEntitiesUploadExecutor;
    private final Step prcStep;
    private static final Logger log = ContextLoggerFactory.getLogger(GlobalEntitiesUploadProcessor.class);

    public GlobalEntitiesUploadProcessor(PrcTask<GlobalEntitiesTransferTask> prcTask, V4GlobalEntitiesUploadExecutor v4GlobalEntitiesUploadExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, Step prcStep, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, migrationLogService);
        this.v4GlobalEntitiesUploadExecutor = v4GlobalEntitiesUploadExecutor;
        this.prcStep = prcStep;
    }

    @VisibleForTesting
    GlobalEntitiesUploadProcessor(PrcTask<GlobalEntitiesTransferTask> prcTask, V4GlobalEntitiesUploadExecutor v4GlobalEntitiesUploadExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, Step prcStep, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, heartbeatScheduler, migrationLogService);
        this.v4GlobalEntitiesUploadExecutor = v4GlobalEntitiesUploadExecutor;
        this.prcStep = prcStep;
    }

    @Override
    protected Pair<Step, StepResult> process() {
        log.info("Processing V4 global entities upload. PrcStep id: {}", (Object)this.prcStep.getId());
        this.setProgressOfStepSubTypeStartTime(this.prcStep, StepSubType.GLOBAL_ENTITIES_EXPORT);
        StepResult result = this.v4GlobalEntitiesUploadExecutor.runStepV4(this.prcStep, this.prcTask);
        return Pair.of((Object)this.prcStep, (Object)result);
    }
}

