/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.guardrails.queries.ExampleDataBuilder;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractQuery<T extends QueryResult>
implements AssessmentQuery {
    public static final Duration LONG_QUERY_TIMEOUT = Duration.ofMinutes(15L);
    public static final Duration QUERY_TIMEOUT = Duration.ofMinutes(5L);
    private static final String TIMEOUT_HINT = "javax.persistence.query.timeout";
    private final QueryIds queryId;
    private final EntityManagerTemplate tmpl;
    private final String query;
    private final boolean nativeQuery;
    private final QueryBuilderOptions queryOptions;
    private final T example;

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, QueryBuilderOptions queryOptions, T example) {
        this(queryId, tmpl, query, false, queryOptions, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, T example) {
        this(queryId, tmpl, query, false, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, boolean nativeQuery, T example) {
        this(queryId, tmpl, query, nativeQuery, QueryBuilderOptions.EMPTY, example);
    }

    protected AbstractQuery(QueryIds queryId, EntityManagerTemplate tmpl, String query, boolean nativeQuery, QueryBuilderOptions queryOptions, T example) {
        this.queryId = queryId;
        this.tmpl = tmpl;
        this.query = query;
        this.nativeQuery = nativeQuery;
        this.queryOptions = queryOptions;
        this.example = example;
    }

    protected List<Tuple> listTuples() {
        return StringUtils.isEmpty((CharSequence)this.query) ? Collections.emptyList() : this.prepareQuery(Tuple.class).list();
    }

    protected List<Tuple> formatResultIfNative(List<Tuple> original) {
        return this.nativeQuery ? GuardrailsUtil.formatResult(original) : original;
    }

    protected Tuple firstTupleResult(Tuple defaultValue) {
        return this.firstResult(Tuple.class, defaultValue);
    }

    protected <V> V firstResult(Class<V> cls, V defaultValue) {
        return StringUtils.isEmpty((CharSequence)this.query) ? defaultValue : this.prepareQuery(cls).first().orElse(defaultValue);
    }

    protected <V> V singleResult(Class<V> cls, V defaultValue) {
        return StringUtils.isEmpty((CharSequence)this.query) ? defaultValue : this.prepareQuery(cls).single();
    }

    protected <V> QueryBuilder<V> prepareQuery(Class<V> cls) {
        return this.queryOptions.apply(this.prepareQueryWithTimeout(this.nativeQuery, cls, this.query));
    }

    protected <V> QueryBuilder<V> createNativeQuery(Class<V> cls, String query) {
        return this.prepareQueryWithTimeout(true, cls, query);
    }

    protected Duration getTimeout() {
        return QUERY_TIMEOUT;
    }

    <V> QueryBuilder<V> prepareQueryWithTimeout(boolean nativeQuery, Class<V> cls, String query) {
        return (nativeQuery ? this.tmpl.nativeQuery(cls, query) : this.tmpl.query(cls, query)).hint(TIMEOUT_HINT, (int)this.getTimeout().toMillis());
    }

    protected static ExampleDataBuilder example(String ... columns) {
        return ExampleDataBuilder.columns(columns);
    }

    @Override
    public Map<QueryIds, QueryResult> examples() {
        return ImmutableMap.of((Object)((Object)this.queryId), this.example);
    }

    @Override
    public Map<QueryIds, QueryResult> executeAll() {
        return ImmutableMap.of((Object)((Object)this.queryId), (Object)this.execute());
    }

    @Override
    public Set<QueryIds> queryIds() {
        return ImmutableSet.of((Object)((Object)this.queryId));
    }

    protected abstract QueryResult execute();

    public static interface QueryBuilderOptions {
        public static final QueryBuilderOptions EMPTY = new QueryBuilderOptions(){

            @Override
            public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                return queryBuilder;
            }
        };

        public <V> QueryBuilder<V> apply(QueryBuilder<V> var1);

        public static QueryBuilderOptions param(final String name, final Object value) {
            return new QueryBuilderOptions(){

                @Override
                public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                    return queryBuilder.param(name, value);
                }
            };
        }

        public static QueryBuilderOptions max(final int limit) {
            return new QueryBuilderOptions(){

                @Override
                public <V> QueryBuilder<V> apply(QueryBuilder<V> queryBuilder) {
                    return queryBuilder.max(limit);
                }
            };
        }
    }
}

