/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.util;

import com.atlassian.migration.agent.json.Jsons;
import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;

public class ZipBuilder {
    private final OutputStream outputStream;
    private final String comment;
    private final List<Pair<Path, String>> filesWithZipEntryNames = new ArrayList<Pair<Path, String>>();
    private final Path path;

    public ZipBuilder(OutputStream outputStream, String comment, Path path) {
        this.outputStream = outputStream;
        this.comment = comment;
        this.path = path;
    }

    public void maybeAdd(Path path) {
        this.maybeAdd(path, null);
    }

    public void maybeAdd(Collection<Path> paths, String directoryInZip) {
        paths.forEach(path -> this.maybeAdd((Path)path, directoryInZip));
    }

    public void maybeAdd(Path path, String directoryInZip) {
        if (path != null) {
            this.add(path, directoryInZip);
        }
    }

    public void add(Path path) {
        this.add(path, null);
    }

    public void add(Path path, String directoryInZip) {
        String zipEntryName = this.computeZipEntryName(path, directoryInZip);
        this.filesWithZipEntryNames.add((Pair<Path, String>)Pair.of((Object)path, (Object)zipEntryName));
    }

    private String computeZipEntryName(Path path, String directoryInZip) {
        String resolvedZipEntryName = path.getFileName().toString();
        if (Strings.isNullOrEmpty((String)directoryInZip)) {
            return resolvedZipEntryName;
        }
        return directoryInZip + "/" + resolvedZipEntryName;
    }

    public void create(boolean deleteSourceFiles) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(this.outputStream));){
            zipOutputStream.setComment(this.comment);
            for (Pair<Path, String> fileWithZipEntryName : this.filesWithZipEntryNames) {
                this.addToZip(zipOutputStream, fileWithZipEntryName);
            }
        }
        if (deleteSourceFiles) {
            for (Pair<Path, String> fileWithZipEntryName : this.filesWithZipEntryNames) {
                Files.delete((Path)fileWithZipEntryName.getLeft());
            }
        }
    }

    private void addToZip(ZipOutputStream zipOutputStream, Pair<Path, String> fileWithZipEntryName) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry((String)fileWithZipEntryName.getRight()));
        Files.copy((Path)fileWithZipEntryName.getLeft(), zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public void addJson(Object data, String fileName, String dirName) throws IOException {
        Path file = this.path.resolve(fileName);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(file);
        Files.createFile(file, new FileAttribute[0]);
        Jsons.writeValue(Files.newBufferedWriter(file, new OpenOption[0]), data);
        this.add(file, dirName);
    }
}

