/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.attachment;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.AttachmentCheckMetadata;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckResultFileManager;
import com.atlassian.migration.agent.service.check.attachment.AttachmentPathService;
import com.atlassian.migration.agent.service.check.attachment.DebugListAttachmentDto;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentContext;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentDto;
import com.atlassian.migration.agent.store.AttachmentStore;
import com.atlassian.migration.agent.store.jpa.impl.StatelessResults;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class MissingAttachmentChecker
implements Checker<MissingAttachmentContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MissingAttachmentChecker.class);
    private static final ForkJoinPool CHECK_RUNNER_POOL = new ForkJoinPool(Math.min((int)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 2.0), 8));
    private static final int MIN_SPACE_BATCH_SIZE = 1;
    private static final int MAX_SPACE_BATCH_SIZE = 50;
    static final String MISSING_ATTACHMENT_FILE_PREFIX = "MissingAttachments";
    private static final String PAGE_ID_QUERY_PARAM = "pageId";
    private final AttachmentStore attachmentStore;
    private final AttachmentPathService attachmentPathService;
    private final AttachmentManager attachmentManager;
    private final String baseUrl;
    private final CheckResultFileManager checkResultFileManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;

    public MissingAttachmentChecker(AttachmentStore attachmentStore, AttachmentPathService attachmentPathService, SystemInformationService systemInformationService, CheckResultFileManager checkResultFileManager, AttachmentManager attachmentManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, AnalyticsEventService analyticsEventService) {
        this.attachmentStore = attachmentStore;
        this.attachmentPathService = attachmentPathService;
        this.baseUrl = systemInformationService.getConfluenceInfo().getBaseUrl();
        this.checkResultFileManager = checkResultFileManager;
        this.attachmentManager = attachmentManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
    }

    public CheckResult check(MissingAttachmentContext ctx) {
        log.info("Checking for missing attachments.");
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(ctx.spaceKeys)) {
            return new CheckResult(true);
        }
        try {
            int batchSize = this.getSpaceBatchSize(ctx.spaceKeys.size(), CHECK_RUNNER_POOL.getParallelism(), ctx);
            List missingAttachments = (List)((ForkJoinTask)CHECK_RUNNER_POOL.submit(() -> ((Stream)Lists.partition(new ArrayList<String>(ctx.spaceKeys), (int)batchSize).stream().parallel()).map(this::checkAttachmentsForSpaces).flatMap(Collection::stream).collect(Collectors.toList()))).get();
            long elapsedSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start);
            log.info("Finished check for missing attachments in {} seconds", (Object)elapsedSeconds);
            if (missingAttachments.isEmpty()) {
                return new CheckResult(true, Collections.singletonMap("violationsCount", 0));
            }
            String path = this.checkResultFileManager.writeToJsonFile(MISSING_ATTACHMENT_FILE_PREFIX, missingAttachments);
            return new CheckResult(false, (Map)ImmutableMap.of((Object)"violationsCount", (Object)missingAttachments.size(), (Object)"path", (Object)path));
        }
        catch (Exception e) {
            log.error("Error executing missing attachments check.", (Throwable)e);
            return Checker.buildCheckResultWithExecutionError((int)PreflightErrorCode.GENERIC_ERROR.getCode());
        }
    }

    @VisibleForTesting
    public int getSpaceBatchSize(int totalSpaces, int totalWorkers, MissingAttachmentContext ctx) {
        if (this.migrationDarkFeaturesManager.isMissingAttachmentCheckDynamicParallelismEnabled()) {
            int batchSize = Math.max(1, Math.min(50, (int)Math.ceil((double)totalSpaces / (double)totalWorkers)));
            log.info("Using dynamic parallelism for missing attachment check. Total spaces: {}, Total workers: {}, Batch size: {}", new Object[]{totalSpaces, totalWorkers, batchSize});
            this.sendDynamicParallelismEvent(totalSpaces, totalWorkers, batchSize, ctx);
            return batchSize;
        }
        log.info("Using static parallelism for missing attachment check. Total spaces: {}, Total workers: {}, Batch size: {}", new Object[]{totalSpaces, totalWorkers, 50});
        return 50;
    }

    private List<MissingAttachmentDto> checkAttachmentsForSpaces(List<String> spaceKeys) {
        try (StatelessResults<AttachmentCheckMetadata> attachments = this.attachmentStore.getAttachmentsToCheck(spaceKeys);){
            List<MissingAttachmentDto> list = attachments.stream().flatMap(attachment -> this.checkIfMissing((AttachmentCheckMetadata)attachment).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            return list;
        }
    }

    public DebugListAttachmentDto getAttachmentsForSpace(String spaceKey, long pageNumber) {
        Long numberOfAttachments = this.attachmentStore.countAttachmentsBySpaceKey(spaceKey);
        int numberOfAttachmentsInAPage = 5000;
        long totalNumberOfPages = (long)Math.ceil((double)numberOfAttachments.longValue() / (double)numberOfAttachmentsInAPage);
        if (pageNumber > totalNumberOfPages) {
            return DebugListAttachmentDto.builder().missingAttachmentDto(new ArrayList<MissingAttachmentDto>()).numberOfAttachments(numberOfAttachments).totalNumberOfPages(totalNumberOfPages).build();
        }
        try (StatelessResults<AttachmentCheckMetadata> attachments = this.attachmentStore.getAttachmentsToCheck((List<String>)ImmutableList.of((Object)spaceKey));){
            List<MissingAttachmentDto> attachmentList = attachments.stream().skip((pageNumber - 1L) * (long)numberOfAttachmentsInAPage).limit(numberOfAttachmentsInAPage).flatMap(attachment -> Optional.of(MissingAttachmentDto.builder().attachmentId(attachment.getId()).pageId(attachment.getContainerId()).spaceKey(attachment.getSpaceKey()).name(attachment.getTitle()).path(this.attachmentPathService.getAttachmentFilePath((AttachmentCheckMetadata)attachment)).url(this.getViewPageAttachment(attachment.getContainerId())).build()).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            DebugListAttachmentDto debugListAttachmentDto = DebugListAttachmentDto.builder().missingAttachmentDto(attachmentList).numberOfAttachments(numberOfAttachments).totalNumberOfPages(totalNumberOfPages).build();
            return debugListAttachmentDto;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<MissingAttachmentDto> checkIfMissing(AttachmentCheckMetadata attachmentMetadata) {
        Optional<MissingAttachmentDto> optional;
        block14: {
            InputStream ignored;
            block12: {
                Optional<MissingAttachmentDto> optional2;
                block13: {
                    Attachment attachment = this.toConfluenceAttachmentStub(attachmentMetadata);
                    ignored = this.attachmentManager.getAttachmentData(attachment);
                    try {
                        if (ignored != null) break block12;
                        optional2 = Optional.of(this.createMissingAttachmentDto(attachmentMetadata));
                        if (ignored == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            try {
                                log.error("Exception while processing attachment: {id = {}, title = {}}", new Object[]{attachmentMetadata.getId(), attachmentMetadata.getTitle(), e});
                                return Optional.of(this.createMissingAttachmentDto(attachmentMetadata));
                            }
                            catch (Exception e2) {
                                log.error("Error executing missing attachments check. attachment {id = {}, title = {}} ", new Object[]{attachmentMetadata.getId(), attachmentMetadata.getTitle(), e2});
                                throw e2;
                            }
                        }
                    }
                    ignored.close();
                }
                return optional2;
            }
            optional = Optional.empty();
            if (ignored == null) break block14;
            ignored.close();
        }
        return optional;
    }

    private MissingAttachmentDto createMissingAttachmentDto(AttachmentCheckMetadata attachmentMetadata) {
        return MissingAttachmentDto.builder().attachmentId(attachmentMetadata.getId()).pageId(attachmentMetadata.getContainerId()).spaceKey(attachmentMetadata.getSpaceKey()).name(attachmentMetadata.getTitle()).path(this.attachmentPathService.getAttachmentFilePath(attachmentMetadata)).url(this.getViewPageAttachment(attachmentMetadata.getContainerId())).build();
    }

    private Attachment toConfluenceAttachmentStub(AttachmentCheckMetadata attachmentMetadata) {
        Attachment attachment = new Attachment();
        attachment.setId(attachmentMetadata.getId());
        attachment.setVersion(attachmentMetadata.getVersion());
        Page page = new Page();
        page.setId(attachmentMetadata.getContainerId());
        Space space = new Space(attachmentMetadata.getSpaceKey());
        space.setId(attachmentMetadata.getSpaceId());
        attachment.setSpace(space);
        page.setSpace(space);
        attachment.setContainer((ContentEntityObject)page);
        if (attachmentMetadata.getPreviousVersion() != null) {
            Attachment original = new Attachment();
            original.setId(attachmentMetadata.getPreviousVersion().longValue());
            attachment.setOriginalVersion((Versioned)original);
        }
        return attachment;
    }

    public static int retrieveMissingAttachmentsCount(Map<String, Object> details) {
        return Integer.parseInt(details.getOrDefault("violationsCount", 0).toString());
    }

    public String getViewPageAttachment(Long pageId) {
        return UriComponentsBuilder.fromHttpUrl((String)this.baseUrl).path("/pages/viewpageattachments.action").queryParam(PAGE_ID_QUERY_PARAM, new Object[]{pageId}).toUriString();
    }

    private void sendDynamicParallelismEvent(int totalSpaces, int totalWorkers, int batchSize, MissingAttachmentContext ctx) {
        log.info("Sending event for dynamic parallelism for missing attachment check.");
        try {
            EventDto event = this.preflightChecksAnalyticsEventBuilder.buidlPreflightMissingAttachmentsDynamicParallelism(totalSpaces, totalWorkers, batchSize, ctx.planId, ctx.cloudId, ctx.executionId);
            this.analyticsEventService.sendAnalyticsEvent(() -> event);
        }
        catch (Exception e) {
            log.error("Failed to send event for dynamic parallelism for missing attachment check.", (Throwable)e);
        }
    }
}

