/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class MCSAnalyticsEventBuilder {
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;
    private SENSupplier senSupplier;
    private Supplier<Instant> instantSupplier;
    private static final String MCS_TRANSFER = "mcsTransfer";
    private static final String MCS_CONTAINER = "mcsContainer";
    private static final String MCS_MIGRATION = "mcsMigration";
    private static final String EVENT_TYPE = "eventType";
    private static final String UPDATED = "updated";
    private static final String ERROR_FILE = "errorFile";

    public MCSAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier) {
        this(pluginVersionManager, systemInformationService, senSupplier, Instant::now);
    }

    @VisibleForTesting
    MCSAnalyticsEventBuilder(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier, Supplier<Instant> instantSupplier) {
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
    }

    public EventDto buildMCSTransferStatusProgressUpdateOperationalEvent(String eventType, String actionSubjectId, String migrationId, String cloudId, String errorFile, Optional<String> reason) {
        ImmutableMap.Builder<String, Object> attributes = this.getCommonAttributes(eventType, migrationId, cloudId, errorFile, reason);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(UPDATED)).sen(this.senSupplier.get())).actionSubject(MCS_TRANSFER, actionSubjectId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMCSContainerStatusUpdateOperationalEvent(String eventType, String actionSubjectId, String migrationId, String cloudId, String errorFile, Optional<String> reason) {
        ImmutableMap.Builder<String, Object> attributes = this.getCommonAttributes(eventType, migrationId, cloudId, errorFile, reason);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(UPDATED)).sen(this.senSupplier.get())).actionSubject(MCS_CONTAINER, actionSubjectId)).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildMCSMigrationStatusUpdateOperationalEvent(String eventType, String migrationId, String cloudId, String errorFile, Optional<String> reason) {
        ImmutableMap.Builder<String, Object> attributes = this.getCommonAttributes(eventType, migrationId, cloudId, errorFile, reason);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action(UPDATED)).sen(this.senSupplier.get())).actionSubject(MCS_MIGRATION, migrationId)).withAttributes((Map)attributes.build())).build();
    }

    private ImmutableMap.Builder<String, Object> getCommonAttributes(String eventType, String migrationId, String cloudId, String errorFile, Optional<String> reason) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"tenantId", (Object)cloudId);
        attributes.put((Object)"migration", (Object)migrationId);
        attributes.put((Object)EVENT_TYPE, (Object)eventType);
        attributes.put((Object)"reason", (Object)reason.orElse(""));
        attributes.put((Object)ERROR_FILE, (Object)errorFile);
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"confluenceVersion", (Object)confluenceInfo.getVersion());
        return attributes;
    }
}

