/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.rest.ErrorResponse;
import com.atlassian.migration.agent.rest.ErrorResponseCode;
import com.fasterxml.jackson.databind.JsonMappingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    private static final Logger log = LoggerFactory.getLogger(JsonMappingExceptionMapper.class);

    public Response toResponse(JsonMappingException ex) {
        log.error("Failed to process request because of unhandled error", (Throwable)ex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorResponse(ErrorResponseCode.INVALID_PARAMETER, ErrorResponseCode.INVALID_PARAMETER.getMessage())).build();
    }
}

