/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.listener;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.LinkDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerChecker;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class AppListenerMapper
extends AbstractMapper {
    private static final String SUCCESS_DESCRIPTION = "All apps have properly initialized migration listeners";
    private static final String RUNNING_DESCRIPTION = "Checking for missing app migration listener";
    private static final String EXECUTION_ERROR_DESCRIPTION = "We couldn't complete checking for app migration listeners";
    private static final String ERROR_OR_WARNING_DESCRIPTION = "Some apps were unable to initialize their migration listeners";
    private static final String EXECUTION_ERROR_LONG_DESCRIPTION = "Retry the check. If the problem persists, contact Atlassian Support.";
    private final String upmLink;

    public AppListenerMapper(String upmLink) {
        this.upmLink = upmLink;
    }

    protected void inject(CheckResultDto checkResultDto, CheckResult checkResult) {
        Set<AppListenerDto> appsMissingListener;
        switch (checkResultDto.getStatus()) {
            case SUCCESS: {
                checkResultDto.setDescription(SUCCESS_DESCRIPTION);
                break;
            }
            case RUNNING: {
                checkResultDto.setDescription(RUNNING_DESCRIPTION);
                break;
            }
            case ERROR: {
                checkResultDto.setStatus(Status.WARNING);
                checkResultDto.setDescription(ERROR_OR_WARNING_DESCRIPTION);
                break;
            }
            case EXECUTION_ERROR: {
                checkResultDto.setStatus(Status.WARNING);
                checkResultDto.setDescription(EXECUTION_ERROR_DESCRIPTION);
                checkResultDto.setNumberOfOccurrences(Integer.valueOf(1));
                CheckDetailsDto checkDetailsDto = new CheckDetailsDto();
                checkDetailsDto.setLongDescription(EXECUTION_ERROR_LONG_DESCRIPTION);
                checkDetailsDto.setListOfOccurrences(Collections.emptyList());
                checkResultDto.setDetails(checkDetailsDto);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected status " + checkResultDto.getStatus());
            }
        }
        if (checkResult != null && !(appsMissingListener = AppListenerChecker.retrieveAppsMissingListeners(checkResult.details)).isEmpty()) {
            CheckDetailsDto checkDetailsDto = new CheckDetailsDto();
            checkDetailsDto.setListOfOccurrences(new ArrayList<AppListenerDto>(appsMissingListener));
            checkResultDto.setNumberOfOccurrences(Integer.valueOf(appsMissingListener.size()));
            checkResultDto.setDetails(checkDetailsDto);
            checkResultDto.setLink(new LinkDto("", this.upmLink));
        }
    }
}

