/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.migration.agent.entity.ExportType;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.UploadDestinationType;
import com.atlassian.migration.agent.service.analytics.builders.AnalyticsEventBuilderUtil;
import com.atlassian.migration.agent.service.analytics.builders.StepLevelAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.VisibleForTesting;

public class SpaceExportAndUploadAnalyticsEventBuilder {
    private final SENSupplier senSupplier;
    private final Supplier<Instant> instantSupplier;
    private final AnalyticsEventBuilderUtil analyticsEventBuilderUtil;
    private final StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder;

    public SpaceExportAndUploadAnalyticsEventBuilder(SENSupplier senSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this(senSupplier, Instant::now, analyticsEventBuilderUtil, stepLevelAnalyticsEventBuilder);
    }

    @VisibleForTesting
    SpaceExportAndUploadAnalyticsEventBuilder(SENSupplier senSupplier, Supplier<Instant> instantSupplier, AnalyticsEventBuilderUtil analyticsEventBuilderUtil, StepLevelAnalyticsEventBuilder stepLevelAnalyticsEventBuilder) {
        this.senSupplier = senSupplier;
        this.instantSupplier = instantSupplier;
        this.analyticsEventBuilderUtil = analyticsEventBuilderUtil;
        this.stepLevelAnalyticsEventBuilder = stepLevelAnalyticsEventBuilder;
    }

    public EventDto buildSpaceExportStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, ExportType exportType, Map<String, Object> attributes) {
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        eventAttributes.put("spaceExportType", exportType.name());
        eventAttributes.putAll(attributes);
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "exportedAndPostProcessed", spaceKey, step, null, eventAttributes);
    }

    public EventDto buildExportPostProcessedTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, String planId, String taskId, Boolean isGDPRReady) {
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "postProcessed", spaceKey, planId, taskId, isGDPRReady, Collections.emptyMap());
    }

    public EventDto buildSpaceTableExportedToCSVTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, String planId, String taskId, String tableName, String query, String dbType, long timeToFirstRecord, long rowsExported, long charactersExported) {
        Map<String, Object> attributes = this.analyticsEventBuilderUtil.buildTableExportedToCSVTimerEvent(tableName, query, dbType, timeToFirstRecord, rowsExported, charactersExported);
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "tableExportedToCSV", spaceKey, planId, taskId, null, attributes);
    }

    public EventDto buildSpaceExportStartEvent(Step step, ExportType exportType, long spaceId, long startTime) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        stepBuilder.addAttribute("exportType", (Object)exportType.name());
        stepBuilder.addAttribute("space", (Object)spaceId);
        return stepBuilder.build();
    }

    public EventDto buildTeamCalendarExportTimeEvent(long totalTime, Long spaceId, String planId, String taskId) {
        ImmutableMap.Builder<String, Object> attributes = this.analyticsEventBuilderUtil.getBuilderWithCommonAttributes();
        attributes.put((Object)"tcExportTime", (Object)totalTime);
        attributes.put((Object)"planId", (Object)planId);
        attributes.put((Object)"taskId", (Object)taskId);
        return ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("teamCalendarExportTime")).sen(this.senSupplier.get())).actionSubject("spaceId", Long.toString(spaceId))).withAttributes((Map)attributes.build())).build();
    }

    public EventDto buildSpaceUploadStepTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, long uploadSize, UploadDestinationType uploadType) {
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "spaceUploaded", spaceKey, step, (Map<String, Object>)ImmutableMap.of((Object)"uploadSize", (Object)uploadSize, (Object)"uploadDestinationType", (Object)uploadType.name()));
    }

    public EventDto buildMCSFileUploadTimerEvent(boolean stepSuccessful, long totalTime, String spaceKey, Step step, long uploadSize, String filename) {
        return this.stepLevelAnalyticsEventBuilder.buildSpaceStepTimerEvent(stepSuccessful, totalTime, "fileUploadedToMCS", spaceKey, step, (Map<String, Object>)ImmutableMap.of((Object)"uploadSize", (Object)uploadSize, (Object)"fileName", (Object)filename));
    }

    public EventDto buildSpaceUploadStartEvent(Step step, long startTime, UploadDestinationType uploadType, String fileId, String spaceKey) {
        GenericOperationalEvent.Builder stepBuilder = this.analyticsEventBuilderUtil.getBuilderStartedEvent(step, startTime);
        this.analyticsEventBuilderUtil.feedSpaceIdIfPresent(spaceKey, spaceId -> stepBuilder.addAttribute("space", (Object)spaceId));
        stepBuilder.addAttribute("fileId", (Object)fileId);
        stepBuilder.addAttribute("uploadType", (Object)uploadType.name());
        return stepBuilder.build();
    }
}

