/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.context;

import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.udc.utils.UDCMapperUtils;
import com.atlassian.migration.udc.common.model.cloud.CloudSite;
import com.atlassian.migration.udc.context.MigrationScopeManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CCMAMigrationScopeManager
implements MigrationScopeManager {
    private final CloudSiteService cloudSiteService;
    private final PlatformService platformService;

    @NotNull
    public String getMigrationScopeId(@NotNull String cloudId) {
        return this.cloudSiteService.getByCloudId(cloudId).map(this.platformService::getCachedOrCreateMigrationScopeId).orElseThrow(() -> new RuntimeException("Failed to create migration scope in MCS"));
    }

    @NotNull
    public String getMigrationScope(@NotNull CloudSite cloudSite) {
        return this.platformService.getCachedOrCreateMigrationScopeId(UDCMapperUtils.toCloudSite(cloudSite));
    }

    @Generated
    public CCMAMigrationScopeManager(CloudSiteService cloudSiteService, PlatformService platformService) {
        this.cloudSiteService = cloudSiteService;
        this.platformService = platformService;
    }
}

