/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GuardrailsFeatureFlagHelperService;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.ListQuery;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;

public class SizeOfNonPersonalSpacesQuery
extends ListQuery {
    private static final int LIMIT = 10;
    private final GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService;

    public SizeOfNonPersonalSpacesQuery(EntityManagerTemplate tmpl, GuardrailsFeatureFlagHelperService guardrailsFeatureFlagHelperService) {
        super(QueryIds.SIZE_OF_NON_PERSONAL_SPACES, tmpl, "select cast(sum(cp.longval)/1024/1024/1024 as big_decimal) as space_size, max(s.id) as space_id, s.type as space_type, s.status as space_status from Space as s inner join Content as c on s.id = c.space.id left outer join ContentProperty as cp on c.id = cp.content where s.type = 'global' and s.status = 'CURRENT' and s.key is not null and s.name is not null and s.type is not null and s.status is not null group by s.key, s.name, s.type, s.status order by space_size desc", SizeOfNonPersonalSpacesQuery.example("space_size", "space_id", "space_type", "space_status").addRow(new BigDecimal("10889.74"), 622593L, "global", "CURRENT").addRow(new BigDecimal("6334.62"), 1019674625L, "global", "DRAFT"));
        this.guardrailsFeatureFlagHelperService = guardrailsFeatureFlagHelperService;
    }

    @Override
    public ListResult execute() {
        Stream<Tuple> resultStream = this.prepareQuery(Tuple.class).stream().filter(t -> t.get(0) != null);
        if (this.guardrailsFeatureFlagHelperService.recordsLimit() != null) {
            resultStream = resultStream.limit(10L);
        }
        List<Tuple> finalResult = resultStream.collect(Collectors.toList());
        return new ListResult(finalResult);
    }
}

