/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.prc;

import com.atlassian.migration.agent.mapi.external.model.PublicApiException;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.prc.model.PollerTaskContext;
import com.atlassian.migration.prc.client.PollerExecutionService;
import com.atlassian.migration.prc.client.PrcServiceClient;
import com.atlassian.migration.prc.client.model.StartPollTaskResponse;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.model.config.ScheduledPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.client.poller.ScheduledPrcPoller;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrcPollerExecutionService
implements PollerExecutionService,
JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrcPollerExecutionService.class);
    private static final String PRC_POLLER_JOB_RUNNER_KEY = "migration-plugin:prc-poller-runner-key.";
    private static final String PRC_POLLER_JOB_ID = "migration-plugin:prc-poller-job-id.";
    private static final String POLLER_STARTED = "Poller started successfully for cloudId = %s";
    private static final String JOB_START_TIME = "jobStartTime";
    private static final List<String> TEST_COMMAND = Collections.singletonList("TEST_POLL");
    private static final ConcurrentMap<String, PollerTaskContext> cloudSitePollers = new ConcurrentHashMap<String, PollerTaskContext>();
    private final SchedulerService schedulerService;
    private final PollerConfigHandler pollerConfigHandler;
    private final OnDemandPrcPoller onDemandPrcPoller;

    public PrcPollerExecutionService(SchedulerService schedulerService, PollerConfigHandler pollerConfigHandler, OnDemandPrcPoller onDemandPrcPoller) {
        this.schedulerService = schedulerService;
        this.pollerConfigHandler = pollerConfigHandler;
        this.onDemandPrcPoller = onDemandPrcPoller;
    }

    @PostConstruct
    public void init() {
        this.schedulerService.registerJobRunner(JobRunnerKey.of((String)PRC_POLLER_JOB_RUNNER_KEY), (JobRunner)this);
    }

    @PreDestroy
    public void cleanUp() {
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)PRC_POLLER_JOB_RUNNER_KEY));
    }

    @NotNull
    public StartPollTaskResponse handlePolling(ScheduledPollerConfig pollerConfig) {
        try {
            Map<String, Serializable> jobParams = this.pollerConfigHandler.getJobParametersFromConfig(pollerConfig);
            jobParams.put(JOB_START_TIME, Long.valueOf(System.currentTimeMillis()));
            Long intervalTimeInMillis = (long)pollerConfig.getPollingDelayInSec() * 1000L;
            this.pollInitial(pollerConfig);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)PRC_POLLER_JOB_RUNNER_KEY)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)intervalTimeInMillis, null)).withParameters(jobParams);
            this.schedulerService.scheduleJob(this.getJobId(pollerConfig.getCloudId()), jobConfig);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
        return new StartPollTaskResponse(String.format(POLLER_STARTED, pollerConfig.getCloudId()));
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Object scheduledPrcPoller = null;
        try {
            Map jobParams = jobRunnerRequest.getJobConfig().getParameters();
            ScheduledPollerConfig pollerConfig = this.pollerConfigHandler.getScheduledPollerConfigFromJobParams(jobParams);
            Long startTime = (Long)jobParams.get(JOB_START_TIME);
            this.pollTask(startTime, pollerConfig);
            return JobRunnerResponse.success();
        }
        catch (PublicApiException.ResourceNotFound ex) {
            this.schedulerService.unscheduleJob(jobRunnerRequest.getJobId());
            return JobRunnerResponse.aborted((String)ex.getMessage());
        }
        catch (Exception ex) {
            if (scheduledPrcPoller != null && scheduledPrcPoller.shouldBeTerminated((Throwable)ex)) {
                log.info("PRC Poller scheduled job is terminated for cloudId : {} with error : {}", (Object)scheduledPrcPoller.getPollerConfig().getCloudId(), (Object)ex.getMessage());
                this.schedulerService.unscheduleJob(jobRunnerRequest.getJobId());
                return JobRunnerResponse.aborted((String)ex.getMessage());
            }
            return JobRunnerResponse.failed((Throwable)ex);
        }
    }

    private ScheduledPrcPoller pollTask(Long startTime, ScheduledPollerConfig pollerConfig) {
        this.createPollerIfNotExist(startTime, pollerConfig);
        ScheduledPrcPoller prcPollTask = ((PollerTaskContext)cloudSitePollers.get(pollerConfig.getCloudId())).getScheduledPrcPoller();
        prcPollTask.pollAndExecute();
        return prcPollTask;
    }

    private void pollInitial(ScheduledPollerConfig pollerConfig) {
        OnDemandPollerConfig onDemandPollerConfigWithCallbacks = this.pollerConfigHandler.getOnDemandPollerConfigWithCallbacks(pollerConfig.getChannelName(), pollerConfig.getCloudId(), pollerConfig.getContainerToken(), TEST_COMMAND);
        this.onDemandPrcPoller.pollAndDeliver(onDemandPollerConfigWithCallbacks);
    }

    private JobId getJobId(String cloudId) {
        return JobId.of((String)(PRC_POLLER_JOB_ID + cloudId));
    }

    void createPollerIfNotExist(Long requestStartTime, ScheduledPollerConfig pollerConfig) {
        String cloudId = pollerConfig.getCloudId();
        PollerTaskContext pollerTaskContext = (PollerTaskContext)cloudSitePollers.get(cloudId);
        Long existingJobStartTime = pollerTaskContext != null ? pollerTaskContext.getJobStartTime() : 0L;
        if (requestStartTime > existingJobStartTime) {
            ScheduledPrcPoller prcPollTask = new ScheduledPrcPoller(pollerConfig, new PrcServiceClient());
            prcPollTask.setToRunning();
            cloudSitePollers.put(cloudId, new PollerTaskContext(requestStartTime, prcPollTask));
        }
    }

    public ScheduledPrcPoller getExistingScheduledPrcPoller(String cloudId) {
        return cloudSitePollers.get(cloudId) != null ? ((PollerTaskContext)cloudSitePollers.get(cloudId)).getScheduledPrcPoller() : null;
    }
}

