/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.newexport.DbType;
import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.guardrails.SeparateFileQuery;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class AssessmentQueries {
    private final DialectResolver dialectResolver;
    private final List<AssessmentQuery> queryList;
    private final Map<QueryIds, AssessmentQuery> queryMap;
    private final Map<DbType, Set<QueryIds>> queriesToSkipPerDBMap;

    public AssessmentQueries(DialectResolver dialectResolver, List<AssessmentQuery> queryList) {
        this(dialectResolver, queryList, (Map<DbType, Set<QueryIds>>)ImmutableMap.of());
    }

    public AssessmentQueries(DialectResolver dialectResolver, List<AssessmentQuery> queryList, Map<DbType, Set<QueryIds>> queriesToSkipPerDBMap) {
        this.dialectResolver = dialectResolver;
        this.queryList = ImmutableList.copyOf(queryList);
        this.queryMap = ImmutableMap.copyOf(queryList.stream().flatMap(query -> query.queryIds().stream().map(id -> Pair.of((Object)id, (Object)query))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        this.queriesToSkipPerDBMap = queriesToSkipPerDBMap;
    }

    public List<String> executeAllQueries() {
        return this.queryList.stream().flatMap(this::executeQueryForL1).collect(Collectors.toList());
    }

    public String executeQuery(QueryIds queryId) {
        return this.queryMap.get((Object)queryId).executeAll().get((Object)queryId).generateResult();
    }

    private Stream<String> executeQueryForL1(AssessmentQuery assessmentQuery) {
        return assessmentQuery.executeAll().entrySet().stream().map(entry -> ((QueryIds)((Object)((Object)entry.getKey()))).name() + ":" + ((QueryResult)entry.getValue()).generateResult());
    }

    public boolean shouldSkip(AssessmentQuery query) {
        Set<QueryIds> toSkip = this.queriesToSkipPerDBMap.getOrDefault((Object)this.dialectResolver.getDbType(), (Set<QueryIds>)ImmutableSet.of());
        return query.queryIds().stream().anyMatch(toSkip::contains);
    }

    public List<AssessmentQuery> getQueries() {
        return this.queryList;
    }

    public int queriesCount() {
        return this.queryList.size();
    }

    public AssessmentQuery getQuery(QueryIds queryIds) {
        return this.queryMap.get((Object)queryIds);
    }

    public boolean addSeparateFile(QueryIds queryId, String date, InstanceMetadataDto instanceMetadata, ZipBuilder zipBuilder) throws IOException {
        AssessmentQuery query = this.getQuery(queryId);
        return query instanceof SeparateFileQuery && this.addSeparateFile(query, queryId, date, instanceMetadata, query.executeAll().get((Object)queryId).generateResult(), zipBuilder);
    }

    public boolean addSeparateFile(QueryIds queryId, String date, InstanceMetadataDto instanceMetadata, String response, ZipBuilder zipBuilder) throws IOException {
        return this.addSeparateFile(this.getQuery(queryId), queryId, date, instanceMetadata, response, zipBuilder);
    }

    private boolean addSeparateFile(AssessmentQuery query, QueryIds queryId, String date, InstanceMetadataDto instanceMetadata, String response, ZipBuilder zipBuilder) throws IOException {
        if (query instanceof SeparateFileQuery) {
            ((SeparateFileQuery)query).addToZip(queryId, date, instanceMetadata.getServerId(), instanceMetadata.getAssessmentDate(), instanceMetadata.getInstanceTimezone(), response, zipBuilder);
            return true;
        }
        return false;
    }

    @Generated
    public List<AssessmentQuery> getQueryList() {
        return this.queryList;
    }
}

