/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.dto.UserDomainCountDto;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.entity.DomainRuleBehaviour;
import com.atlassian.migration.agent.mma.service.MigrationMetadataAggregatorService;
import com.atlassian.migration.agent.newexport.SpaceCSVExportTaskContext;
import com.atlassian.migration.agent.newexport.SpaceRapidExporter;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.MigrationMappingService;
import com.atlassian.migration.agent.service.check.CheckResultCSVWriter;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.check.attachment.DebugListAttachmentDto;
import com.atlassian.migration.agent.service.check.attachment.MissingAttachmentChecker;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.atlassian.migration.agent.service.check.csv.MissingAttachmentCSVBean;
import com.atlassian.migration.agent.service.check.csv.MissingAttachmentCSVContainer;
import com.atlassian.migration.agent.service.extract.UserGroupExtractFacade;
import com.atlassian.migration.agent.service.guardrails.AssessmentQueries;
import com.atlassian.migration.agent.service.impl.SpaceStatisticCalculationInitialExecutor;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.migration.agent.service.prc.model.RetryCMAState;
import com.atlassian.migration.agent.service.status.MigrationStatusService;
import com.atlassian.migration.agent.service.status.PlanStatusDto;
import com.atlassian.migration.agent.service.status.StepStatusDto;
import com.atlassian.migration.agent.service.status.TaskStatusDto;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.scheduler.SchedulerServiceException;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jersey.spi.container.ResourceFilters;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonCreator;

@ParametersAreNonnullByDefault
@Path(value="debug")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Produces(value={"application/json"})
public class DebugResource {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String USER_DOMAIN_RULE_SELECTION_URI = "/admin/migration.action#choose-domains";
    public static final String PLACEHOLDER = "placeholder";
    private final PreflightService preflightService;
    private final UserGroupExtractFacade userGroupExtractFacade;
    private final MigrationStatusService migrationStatusService;
    private final SpaceRapidExporter spaceRapidExporter;
    private final SpaceManager spaceManager;
    private final BootstrapManager bootstrapManager;
    private final MigrationMappingService migrationMappingService;
    private final UserDomainService userDomainService;
    private final AssessmentQueries assessmentQueries;
    private final SpaceStatisticCalculationInitialExecutor spaceStatisticCalculationInitialExecutor;
    private final MigrationMetadataAggregatorService migrationMetadataAggregatorService;
    private final MissingAttachmentChecker missingAttachmentChecker;
    private final SystemInformationService sysInfoService;

    @Inject
    public DebugResource(PreflightService preflightService, UserGroupExtractFacade userGroupExtractFacade, MigrationStatusService migrationStatusService, SpaceRapidExporter spaceRapidExporter, SpaceManager spaceManager, BootstrapManager bootstrapManager, MigrationMappingService migrationMappingService, UserDomainService userDomainService, AssessmentQueries assessmentQueries, SpaceStatisticCalculationInitialExecutor spaceStatisticCalculationInitialExecutor, MigrationMetadataAggregatorService migrationMetadataAggregatorService, MissingAttachmentChecker missingAttachmentChecker, SystemInformationService sysInfoService) {
        this.preflightService = preflightService;
        this.userGroupExtractFacade = userGroupExtractFacade;
        this.migrationStatusService = migrationStatusService;
        this.spaceRapidExporter = spaceRapidExporter;
        this.spaceManager = spaceManager;
        this.bootstrapManager = bootstrapManager;
        this.migrationMappingService = migrationMappingService;
        this.userDomainService = userDomainService;
        this.assessmentQueries = assessmentQueries;
        this.spaceStatisticCalculationInitialExecutor = spaceStatisticCalculationInitialExecutor;
        this.migrationMetadataAggregatorService = migrationMetadataAggregatorService;
        this.missingAttachmentChecker = missingAttachmentChecker;
        this.sysInfoService = sysInfoService;
    }

    @POST
    @Path(value="/schedule/space-statistic-calculation")
    public Response scheduleSpaceStatisticCalculation() throws SchedulerServiceException {
        return this.spaceStatisticCalculationInitialExecutor.scheduleWithForceUpdate() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    @GET
    @Path(value="/serverId")
    public Response getServerId() {
        String serverId = this.sysInfoService.getConfluenceInfo().getServerId();
        return Response.ok((Object)serverId).build();
    }

    @POST
    @Path(value="/mma/emit-space-data")
    public Response emitSpaceData() {
        this.migrationMetadataAggregatorService.sendSpaceMetadataToMMAForAllCloudSites();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/mma/emit-app-data")
    public Response emitAppData() {
        this.migrationMetadataAggregatorService.sendAppMetadataToMMAForAllCloudSites();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/{cloudId}/full-metadata-refresh")
    public Response fullMetadataRefresh(@PathParam(value="cloudId") String cloudId, @QueryParam(value="shouldRetryApps") @DefaultValue(value="false") Boolean shouldRetryApps, @QueryParam(value="shouldRetryDomains") @DefaultValue(value="false") Boolean shouldRetryDomains, @QueryParam(value="shouldRetryServerInstance") @DefaultValue(value="false") Boolean shouldRetryServerInstance, @QueryParam(value="shouldRetrySpaces") @DefaultValue(value="false") Boolean shouldRetrySpaces) {
        RetryCMAState cmaState = RetryCMAState.builder().shouldRetryApps(shouldRetryApps).shouldRetryDomains(shouldRetryDomains).shouldRetryServerInstance(shouldRetryServerInstance).shouldRetrySpaces(shouldRetrySpaces).build();
        this.migrationMetadataAggregatorService.replaceAllMetadata(cloudId, cmaState);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/mma/view-space-data")
    public Response viewSpaceData() {
        return Response.status((Response.Status)Response.Status.OK).entity(this.migrationMetadataAggregatorService.buildSpaceMetadata(PLACEHOLDER, PLACEHOLDER)).build();
    }

    @GET
    @Path(value="/assess/l1")
    public Response assessInstance() {
        return Response.ok(this.assessmentQueries.executeAllQueries()).build();
    }

    @GET
    @Path(value="/assess/{queryId}")
    public Response assessQuery(@PathParam(value="queryId") String queryId) {
        return Response.ok((Object)this.assessmentQueries.executeQuery(QueryIds.valueOf(queryId))).build();
    }

    @GET
    @Path(value="/attachments/{planId}")
    public Response debugAttachments(@PathParam(value="planId") String planId) {
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        CheckResultCSVContainer checkResultCSVContainer = this.preflightService.createCheckResultCSVContainer(planId, CheckType.MISSING_ATTACHMENTS);
        String contentDisposition = String.format("attachment; filename=\"%s-%s.csv\"; creation-date=\"%s\"", planId, CheckType.MISSING_ATTACHMENTS.value(), DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
        return Response.ok(output -> writer.writeResultsInStream(output, checkResultCSVContainer)).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)contentDisposition).build();
    }

    @POST
    @Path(value="/export/space")
    public Response exportSpace(ExportSpacesRequest request) throws Exception {
        String cloudId = String.format("Debug space export dummy PlanId %s", UUID.randomUUID());
        String planId = String.format("Debug space export dummy PlanId %s", UUID.randomUUID());
        String taskId = String.format("Debug space export dummy TaskId %s", UUID.randomUUID());
        String spaceKey = request.getSpaceKey();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The specified space does not exist.").build();
        }
        SpaceCSVExportTaskContext config = new SpaceCSVExportTaskContext(space.getId(), space.getKey(), cloudId, planId, taskId, SpaceExportExecutor.getFilePathProperty(this.bootstrapManager), false);
        String exportPath = this.spaceRapidExporter.export(config);
        return Response.ok((Object)new ExportSpacesResponse(exportPath, spaceKey)).build();
    }

    @GET
    @Path(value="/extraction/cache/clear/{spaceKey}")
    public Response clearCacheBySpaceKey(@PathParam(value="spaceKey") String spaceKey) {
        this.userGroupExtractFacade.clearCache(spaceKey);
        return Response.ok().build();
    }

    @GET
    @Path(value="/status/plan")
    public Response getAllPlans() {
        List<PlanStatusDto> planStatusDtoList = this.migrationStatusService.getAllPlans();
        return Response.ok(planStatusDtoList).build();
    }

    @GET
    @Path(value="/status/plan/{planId}")
    public Response getTasksByPlanId(@PathParam(value="planId") String planId) {
        List<TaskStatusDto> tasks = this.migrationStatusService.getTasksByPlan(planId);
        return Response.ok(tasks).build();
    }

    @GET
    @Path(value="/status/plan/{planId}/{spaceKey}")
    public Response getDetailsByPlanAndSpaceKey(@PathParam(value="planId") String planId, @PathParam(value="spaceKey") String spaceKey) {
        Map<String, Object> migrationStatus = this.migrationStatusService.getDetailsByPlanAndSpaceKey(planId, spaceKey);
        return Response.ok(migrationStatus).build();
    }

    @GET
    @Path(value="/status/task/{taskId}")
    public Response getStepsByTaskId(@PathParam(value="taskId") String taskId) {
        List<StepStatusDto> tasks = this.migrationStatusService.getStepsByTask(taskId);
        return Response.ok(tasks).build();
    }

    @GET
    @Path(value="/mappings/{cloudId}/{migrationScopeId}/{namespace}")
    public Response getMappings(@PathParam(value="cloudId") String cloudId, @PathParam(value="migrationScopeId") String migrationScopeId, @PathParam(value="namespace") String namespace) {
        if (!MigrationMappingService.CONFLUENCE_MAPPINGS.contains((Object)namespace)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new MessageDto(namespace + " is not a valid confluence namespace")).build();
        }
        return Response.ok(this.migrationMappingService.getMappings(cloudId, migrationScopeId, namespace)).build();
    }

    @GET
    @Path(value="/email/trust-all-domains")
    public Response trustAllDomains() throws URISyntaxException {
        List<UserDomainCountDto> domains = this.userDomainService.getUserDomainCounts();
        domains.forEach(domain -> this.userDomainService.upsertDomainRule(new UserDomainRuleDto(domain.getDomainName(), DomainRuleBehaviour.TRUSTED)));
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @GET
    @Path(value="/email/remove-all-domain-rules")
    public Response deleteAllUserDomainRules() throws URISyntaxException {
        this.userDomainService.deleteAllDomainRules();
        return Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT).location(new URI(USER_DOMAIN_RULE_SELECTION_URI)).build();
    }

    @POST
    @Path(value="/extract/attachments/{spaceKey}/{pageNumber}")
    public Response getAttachmentsForSpace(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="pageNumber") int pageNumber) {
        DebugListAttachmentDto debugListAttachmentDto = this.missingAttachmentChecker.getAttachmentsForSpace(spaceKey, pageNumber);
        CheckResultCSVWriter writer = new CheckResultCSVWriter();
        List<MissingAttachmentCSVBean> beans = debugListAttachmentDto.getMissingAttachmentDto().stream().map(MissingAttachmentCSVBean::new).collect(Collectors.toList());
        MissingAttachmentCSVContainer checkResultCSVContainer = new MissingAttachmentCSVContainer(beans);
        String contentDisposition = String.format("attachment; filename=\"%s.csv\"; creation-date=\"%s\"", "Attachments to migrate", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT"))));
        return Response.ok(output -> writer.writeResultsInStream(output, checkResultCSVContainer)).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)contentDisposition).header("X-Total-Attachments", (Object)debugListAttachmentDto.getNumberOfAttachments()).header("X-Total-Pages", (Object)debugListAttachmentDto.getTotalNumberOfPages()).header("X-Current-Page", (Object)pageNumber).build();
    }

    public static final class ExportSpacesRequest {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String spaceKey;

        @JsonCreator
        @com.fasterxml.jackson.annotation.JsonCreator
        public ExportSpacesRequest(@org.codehaus.jackson.annotate.JsonProperty(value="spaceKey") @JsonProperty(value="spaceKey") String spaceKey) {
            this.spaceKey = spaceKey;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }
    }

    public static final class ExportSpacesResponse {
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String location;
        @org.codehaus.jackson.annotate.JsonProperty
        @JsonProperty
        private final String spaceKey;

        public ExportSpacesResponse(String location, String spaceKey) {
            this.location = location;
            this.spaceKey = spaceKey;
        }

        @Generated
        public String getLocation() {
            return this.location;
        }

        @Generated
        public String getSpaceKey() {
            return this.spaceKey;
        }
    }
}

