/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.email;

import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.udc.auth.ContainerTokenProvider;
import com.atlassian.migration.udc.common.model.context.Context;
import com.atlassian.migration.udc.context.MigrationScopeManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CloudContextProvider
extends com.atlassian.migration.udc.context.CloudContextProvider {
    private final ContainerTokenProvider containerTokenProvider;
    private final MigrationScopeManager migrationScopeManager;
    private final CloudSiteService cloudSiteService;

    @NotNull
    public Context.CloudContext getCloudContext(@NotNull String cloudId) {
        String containerToken = this.containerTokenProvider.getContainerToken(cloudId);
        String migrationScopeId = this.migrationScopeManager.getMigrationScopeId(cloudId);
        return new Context.CloudContext(containerToken, migrationScopeId);
    }

    public String getCloudId(@NotNull Context context) {
        return this.getCloudIdContext(context).getCloudId();
    }

    public Context.CloudContext getCloudContext(Context context) {
        Context.CloudContext resolvedContext;
        if (context instanceof Context.CloudContext) {
            resolvedContext = (Context.CloudContext)context;
        } else if (context instanceof Context.CloudIdContext) {
            resolvedContext = this.getCloudContext(((Context.CloudIdContext)context).getCloudId());
        } else {
            throw new IllegalArgumentException("Unsupported context type: " + context.getClass().getName());
        }
        return resolvedContext;
    }

    public Context.CloudIdContext getCloudIdContext(Context context) {
        if (context instanceof Context.CloudIdContext) {
            return (Context.CloudIdContext)context;
        }
        if (context instanceof Context.CloudContext) {
            Context.CloudContext cloudContext = (Context.CloudContext)context;
            if (cloudContext.getContainerToken() == null) {
                throw new IllegalArgumentException("Cloud context does not have container token");
            }
            CloudSite cloudSite = this.cloudSiteService.getByContainerToken(cloudContext.getContainerToken()).orElseThrow(() -> new IllegalArgumentException("CloudSite not found for container token: " + cloudContext.getContainerToken()));
            return new Context.CloudIdContext(cloudSite.getCloudId());
        }
        throw new IllegalArgumentException("Unsupported context type: " + context.getClass().getName());
    }

    @Generated
    public CloudContextProvider(ContainerTokenProvider containerTokenProvider, MigrationScopeManager migrationScopeManager, CloudSiteService cloudSiteService) {
        this.containerTokenProvider = containerTokenProvider;
        this.migrationScopeManager = migrationScopeManager;
        this.cloudSiteService = cloudSiteService;
    }
}

