/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.prc;

import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.prc.model.PrcRequest;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class PrcOkHttpAdapter {
    private static final Logger log = LoggerFactory.getLogger(PrcOkHttpAdapter.class);
    private EnterpriseGatekeeperClient enterpriseGatekeeperClient;

    public PrcOkHttpAdapter(EnterpriseGatekeeperClient enterpriseGatekeeperClient) {
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
    }

    @NotNull
    public com.atlassian.migration.prc.client.Response post(@NotNull URL url, @NotNull Map<String, String> map, @NotNull PrcRequest prcRequest, @NotNull Boolean retryable) {
        Request.Builder requestBuilder = new Request.Builder().url(url).post(RequestBody.create((String)Jsons.valueAsString(prcRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE));
        map.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        return this.callAndReturnResponse(requestBuilder, retryable);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    com.atlassian.migration.prc.client.Response callAndReturnResponse(Request.Builder requestBuilder, Boolean retryable) {
        try (Response response = retryable != false ? this.enterpriseGatekeeperClient.callStreamWithRetriesAndReturnResponse(requestBuilder.build(), (Set<Integer>)ImmutableSet.of((Object)HttpStatus.UNAUTHORIZED.value())) : this.enterpriseGatekeeperClient.callStreamAndReturnResponse(requestBuilder.build(), (Set<Integer>)ImmutableSet.of((Object)HttpStatus.UNAUTHORIZED.value()));){
            com.atlassian.migration.prc.client.Response response2;
            block14: {
                InputStream inputStream = response.body().byteStream();
                try {
                    Byte[] responseBodyObject = ArrayUtils.toObject((byte[])IOUtils.toByteArray((InputStream)inputStream));
                    response2 = new com.atlassian.migration.prc.client.Response(response.code(), responseBodyObject);
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return response2;
        }
        catch (IOException e) {
            log.error("Error occurred while executing post request with message : {}", (Object)e.getMessage());
            return new com.atlassian.migration.prc.client.Response(500, ArrayUtils.toObject((byte[])e.getMessage().getBytes()));
        }
    }

    @NotNull
    public com.atlassian.migration.prc.client.Response put(@NotNull URL url, @NotNull Map<String, String> map, @NotNull PrcRequest prcRequest, @NotNull Boolean retryable) {
        Request.Builder requestBuilder = new Request.Builder().url(url).put(RequestBody.create((String)Jsons.valueAsString(prcRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE));
        map.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        return this.callAndReturnResponse(requestBuilder, retryable);
    }
}

