/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.statsig.HashAlgo;
import com.atlassian.fx3.statsig.StatsigHash;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.featureflag.StatsigDynamicConfigs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StatsigFeatureGateNameMapper {
    private final Map<String, String> map = new HashMap<String, String>();

    public StatsigFeatureGateNameMapper(Set<String> flagSet) {
        for (String flag : flagSet) {
            this.map.put(StatsigHash.Companion.getHashForHashAlgo(flag, HashAlgo.DJB2), flag);
        }
    }

    public StatsigFeatureGateNameMapper(Class<MigrationDarkFeaturesManager> migrationDarkFeaturesManagerClass, Class<StatsigDynamicConfigs> statsigDynamicConfigsClass) {
        Set combinedFlagsAndConfigs = Stream.concat(Arrays.stream(MigrationDarkFeaturesManager.FeatureFlags.values()).map(MigrationDarkFeaturesManager.FeatureFlags::getFlagName), Arrays.stream(StatsigDynamicConfigs.values()).map(StatsigDynamicConfigs::getConfigName)).collect(Collectors.toSet());
        for (String flag : combinedFlagsAndConfigs) {
            this.map.put(StatsigHash.Companion.getHashForHashAlgo(flag, HashAlgo.DJB2), flag);
        }
    }

    public String getFeatureFlagName(String hashedStatsigFeatureGateName) {
        return this.map.get(hashedStatsigFeatureGateName);
    }
}

