/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.model;

import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;

public class DelayedBlockingQueue<E>
extends ArrayBlockingQueue<E> {
    private static final long DELAY_DURATION_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private static final long TEN_MIN_DURATION = DELAY_DURATION_INTERVAL * 5L;
    private static final List<Pair<Long, Long>> DELAY = new LinkedList<Pair<Long, Long>>(){
        {
            this.add(Pair.of((Object)DELAY_DURATION_INTERVAL, (Object)500L));
            this.add(Pair.of((Object)(DELAY_DURATION_INTERVAL * 2L), (Object)400L));
            this.add(Pair.of((Object)(DELAY_DURATION_INTERVAL * 3L), (Object)300L));
            this.add(Pair.of((Object)(DELAY_DURATION_INTERVAL * 4L), (Object)200L));
            this.add(Pair.of((Object)(DELAY_DURATION_INTERVAL * 5L), (Object)100L));
        }
    };
    private final Instant startTime = Instant.now();

    public DelayedBlockingQueue(int capacity) {
        super(capacity);
    }

    private void addDelay() {
        long elapsedTime = Duration.between(this.startTime, Instant.now()).toMillis();
        if (elapsedTime >= TEN_MIN_DURATION) {
            return;
        }
        for (Pair<Long, Long> entry : DELAY) {
            if (elapsedTime >= (Long)entry.getLeft()) continue;
            this.delay((Long)entry.getRight());
            return;
        }
    }

    private void delay(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean offer(E e) {
        this.addDelay();
        return super.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addDelay();
        return super.offer(e, timeout, unit);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.addDelay();
        super.put(e);
    }
}

