/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsTupleElement;
import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipEntityCounts;
import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipFetcher;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.guardrails.results.LongResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;

public class NestedGroupQuery
implements AssessmentQuery {
    private static final int GROUP_SIZE_LIMIT = 35000;
    private static final int LIMIT = 100;
    public static final String GROUP_ID = "group_id";
    public static final String MEMBERSHIP_COUNT = "membership_count";
    public static final String NUMBER_OF_GROUPS = "number_of_groups";
    public static final String USER_ID = "user_id";
    private static final MembershipCounts EXAMPLE = new MembershipCounts(new MembershipEntityCounts(new long[]{309231646L, 676233217L}, new long[]{507L, 558L}), new MembershipEntityCounts(new long[]{778633284L, 897417465L}, new long[]{13674L, 13666L}));
    private final MembershipFetcher membershipFetcher;

    public NestedGroupQuery(MembershipFetcher membershipFetcher) {
        this.membershipFetcher = membershipFetcher;
    }

    @Override
    public Map<QueryIds, QueryResult> executeAll() {
        MembershipCounts membershipCounts = this.membershipFetcher.processDirectories();
        return ImmutableMap.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)this.executeNestedMembership(membershipCounts), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)this.executeNestedGroupsPerUser(membershipCounts), (Object)((Object)QueryIds.GROUP), (Object)this.executeNestedGroup(membershipCounts), (Object)((Object)QueryIds.ALL_USERS), (Object)this.executeAllUsers(membershipCounts));
    }

    @Override
    public Map<QueryIds, QueryResult> examples() {
        return ImmutableMap.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)this.executeNestedMembership(EXAMPLE), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)this.executeNestedGroupsPerUser(EXAMPLE), (Object)((Object)QueryIds.GROUP), (Object)this.executeNestedGroup(EXAMPLE), (Object)((Object)QueryIds.ALL_USERS), (Object)this.executeAllUsers(EXAMPLE));
    }

    @Override
    public Set<QueryIds> queryIds() {
        return ImmutableSet.of((Object)((Object)QueryIds.NESTED_GROUPS_WITH_35K_OR_MORE_USER_MEMBERSHIPS), (Object)((Object)QueryIds.GROUPS_PER_USER), (Object)((Object)QueryIds.GROUP), (Object)((Object)QueryIds.ALL_USERS));
    }

    public ListResult executeNestedMembership(MembershipCounts membershipCounts) {
        MembershipEntityCounts groups = membershipCounts.getGroups();
        if (groups.getMaxCount() >= 35000L) {
            return new ListResult(groups.getIdsHavingAtLeast(35000L, this::buildMembershipTuple));
        }
        return new ListResult(groups.getTopIds(100L, this::buildMembershipTuple));
    }

    private QueryResult executeNestedGroupsPerUser(MembershipCounts membershipCounts) {
        return new ListResult(membershipCounts.getUsers().getTopIds(100L, this::buildGroupTuple));
    }

    private QueryResult executeNestedGroup(MembershipCounts membershipCounts) {
        return new LongResult(Long.valueOf(membershipCounts.getGroups().getIds().length));
    }

    private QueryResult executeAllUsers(MembershipCounts membershipCounts) {
        return new LongResult(Long.valueOf(membershipCounts.getUsers().getIds().length));
    }

    private Tuple buildMembershipTuple(long id, long count) {
        return GuardrailsUtil.getTuple(new GuardrailsTupleElement<Long>(GROUP_ID, id, Long.class), new GuardrailsTupleElement<Long>(MEMBERSHIP_COUNT, count, Long.class));
    }

    private Tuple buildGroupTuple(long id, long count) {
        return GuardrailsUtil.getTuple(new GuardrailsTupleElement<Long>(NUMBER_OF_GROUPS, count, Long.class), new GuardrailsTupleElement<Long>(USER_ID, id, Long.class));
    }
}

