/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.util;

import com.atlassian.fx3.statsig.DynamicConfigAttributes;
import com.atlassian.migration.agent.service.featureflag.StatsigDynamicConfigs;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class StatsigUtils {
    private StatsigUtils() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static Boolean getBooleanConfigValue(DynamicConfigAttributes configAttributes) {
        return BooleanUtils.toBoolean((String)configAttributes.getValue().getValue().toString());
    }

    public static String getStringConfigValue(DynamicConfigAttributes configAttributes) {
        return configAttributes.getValue().getValue().toString();
    }

    public static Double getNumberConfigValue(DynamicConfigAttributes configAttributes) {
        try {
            return Double.parseDouble(configAttributes.getValue().getValue().toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(StatsigUtils.generateErrorMessage(configAttributes.getName(), StatsigDynamicConfigs.ConfigType.NUMBER.toString()), e);
        }
    }

    public static List<String> getListOfStringConfigValue(DynamicConfigAttributes configAttributes) {
        return StatsigUtils.getListOfObjects(configAttributes, new TypeToken<List<String>>(){});
    }

    public static List<Double> getListOfNumbersConfigValue(DynamicConfigAttributes configAttributes) {
        return StatsigUtils.getListOfObjects(configAttributes, new TypeToken<List<Double>>(){});
    }

    private static <T> List<T> getListOfObjects(DynamicConfigAttributes configAttributes, TypeToken<List<T>> typeToken) {
        try {
            Gson gson = new Gson();
            String jsonString = gson.toJson(configAttributes.getValue().getValue());
            return (List)gson.fromJson(jsonString, typeToken.getType());
        }
        catch (JsonSyntaxException e) {
            StatsigDynamicConfigs.ConfigType configType = typeToken.getType().equals(new TypeToken<List<Double>>(){}) ? StatsigDynamicConfigs.ConfigType.NUMBER : StatsigDynamicConfigs.ConfigType.STRING;
            throw new IllegalArgumentException(StatsigUtils.generateErrorMessage(configAttributes.getName(), configType.toString()), e);
        }
    }

    private static String generateErrorMessage(String configName, String configType) {
        return String.format("The value for config %s is not a valid %s. Please check the config type.", configName, configType);
    }

    public static StatsigDynamicConfigs getConfigByName(String configName) {
        for (StatsigDynamicConfigs config : StatsigDynamicConfigs.values()) {
            if (!config.getConfigName().equals(configName)) continue;
            return config;
        }
        return null;
    }
}

