/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import java.util.Collections;
import java.util.Optional;

public class SpaceUsersMigrationShadowExecutor
extends ShadowMigrationExecutor {
    private final ProgressTracker progressTracker;
    private final String SUCCESS_MESSAGE = "Space users migration completed.";
    private final String EXPORT_SUCCESS_MESSAGE = "Data export successful. ";

    public SpaceUsersMigrationShadowExecutor(StepStore stepStore, ProgressTracker progressTracker) {
        super(stepStore);
        this.progressTracker = progressTracker;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        this.sendProgressUpdate(stepId, prcTask);
        this.sendCompletionStatus(prcTask);
        return StepResult.succeeded("Data export successful. Space users migration completed.", "exportFileId");
    }

    private void sendCompletionStatus(PrcTask prcTask) {
        this.progressTracker.sendV4SpaceUserCompletionStatus(new UsersMigrationV2FilePayload(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()), null, "exportFileId", prcTask, "Shadow Migration - Data export successful. Space users migration completed.");
    }

    private void sendProgressUpdate(String stepId, PrcTask prcTask) {
        this.progressTracker.progress(stepId, 100, StepType.CONFLUENCE_EXPORT.getDisplayName(), StepType.CONFLUENCE_EXPORT.getDetailedStatus(), Collections.emptyMap(), Optional.of(prcTask));
    }
}

