/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.helper.SpaceImportConfigFileManager;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUploadShadowExecutor
extends ShadowMigrationExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceUploadShadowExecutor.class);
    private final ProgressTracker progressTracker;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final SpaceManager spaceManager;
    private final SpaceImportConfigFileManager spaceImportConfigFileManager;
    private final StepStore stepStore;

    public SpaceUploadShadowExecutor(ProgressTracker progressTracker, MigrationDarkFeaturesManager migrationDarkFeaturesManager, SpaceManager spaceManager, SpaceImportConfigFileManager spaceImportConfigFileManager, StepStore stepStore) {
        super(stepStore);
        this.progressTracker = progressTracker;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.spaceManager = spaceManager;
        this.spaceImportConfigFileManager = spaceImportConfigFileManager;
        this.stepStore = stepStore;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        Step originalStep = this.getOriginalStep(prcTask, StepType.DATA_UPLOAD);
        String spaceKey = ((ConfluenceSpaceTask)this.stepStore.getStep(stepId).getTask()).getSpaceKey();
        this.progressTracker.progress(stepId, 100, "Upload complete", StepType.DATA_UPLOAD.getDetailedStatus(), Collections.emptyMap(), Optional.of(prcTask));
        List<MigrationCatalogueStorageFile> uploadedFiles = this.getOriginalStepUploadedFiles(originalStep, spaceKey);
        this.progressTracker.sendV4SpaceUploadCompletionStatus(uploadedFiles, String.valueOf(Objects.requireNonNull(this.spaceManager.getSpace(spaceKey)).getId()), prcTask, "Space upload for shadow migration completed successfully");
        return StepResult.succeeded("Shadow Migration - Data upload successful", "Data Upload Successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MigrationCatalogueStorageFile> getOriginalStepUploadedFiles(Step originalStep, String spaceKey) {
        String spaceId = String.valueOf(Objects.requireNonNull(this.spaceManager.getSpace(spaceKey)).getId());
        List<MigrationCatalogueStorageFile> uploadedFiles = null;
        if (this.migrationDarkFeaturesManager.isReadingSpaceUploadFileConfigFromDBDisabled()) {
            String migrationId = originalStep.getPlan().getMigrationId();
            try {
                uploadedFiles = this.spaceImportConfigFileManager.getSpaceImportStepConfigFromFile(migrationId, spaceId);
            }
            catch (Exception e) {
                log.error("Failed to get space import step config file for migrationId: {} and spaceId: {}", new Object[]{migrationId, spaceId, e});
            }
            finally {
                this.spaceImportConfigFileManager.cleanupSpaceImportStepConfigFile(migrationId, spaceId);
            }
        } else {
            uploadedFiles = (List<MigrationCatalogueStorageFile>)Jsons.readValue(originalStep.getStepMetadata(), (TypeReference)new TypeReference<List<MigrationCatalogueStorageFile>>(){});
        }
        return uploadedFiles;
    }
}

