/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.entity.GuardrailsResponse;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.guardrails.AssessmentQueries;
import com.atlassian.migration.agent.service.guardrails.CpuStatsCalculator;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentService;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentStore;
import com.atlassian.migration.agent.store.guardrails.AssessmentQuery;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseStore;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseType;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.QueryResult;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractQuery;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.persistence.PersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class InstanceAssessmentService
implements JobRunner {
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentService.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.confluence.migration.guardrails.InstanceAssessmentService");
    private static final String DEFAULT_NODE = "defaultClusterNode";
    private static final String SERVER_NODE = "serverNode";
    private final AssessmentQueries assessmentQueries;
    private final SchedulerService schedulerService;
    private final GuardrailsResponseGroupStore guardRailsResponseGroupStore;
    private final GuardrailsResponseStore guardrailsResponseStore;
    private final ClusterInformationService clusterInformationService;
    private final PluginTransactionTemplate ptx;
    private final MacroAssessmentService macroAssessmentService;
    private final MacroAssessmentStore macroAssessmentStore;

    public InstanceAssessmentService(AssessmentQueries assessmentQueries, SchedulerService schedulerService, GuardrailsResponseGroupStore guardRailsResponseGroupStore, GuardrailsResponseStore guardrailsResponseStore, ClusterInformationService clusterInformationService, PluginTransactionTemplate ptx, MacroAssessmentService macroAssessmentService, MacroAssessmentStore macroAssessmentStore) {
        this.assessmentQueries = assessmentQueries;
        this.schedulerService = schedulerService;
        this.guardRailsResponseGroupStore = guardRailsResponseGroupStore;
        this.guardrailsResponseStore = guardrailsResponseStore;
        this.clusterInformationService = clusterInformationService;
        this.ptx = ptx;
        this.macroAssessmentService = macroAssessmentService;
        this.macroAssessmentStore = macroAssessmentStore;
    }

    @PostConstruct
    public void initialize() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @PreDestroy
    public void cleanup() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        try {
            CpuStatsCalculator calculator = CpuStatsCalculator.createCalculator();
            String jobId = request.getJobId().toString();
            String nodeId = this.getNodeId();
            GuardrailsResponseGroup responseGroup = new GuardrailsResponseGroup(jobId, nodeId);
            String responseGroupId = this.ptx.write(() -> this.guardRailsResponseGroupStore.createResponseGroup(responseGroup));
            log.info("Running job for jobId:{}", (Object)jobId);
            BooleanSupplier isAssessmentCanceled = this.isCanceledSupplier(jobId);
            this.executeGuardrailsQueries(responseGroup, isAssessmentCanceled, calculator);
            this.executeMacroAssessment(isAssessmentCanceled, calculator);
            GuardrailsResponseGroup rg = this.guardRailsResponseGroupStore.getResponseGroupByJobId(jobId);
            if (!rg.isCanceled()) {
                this.ptx.write(() -> this.guardRailsResponseGroupStore.completeResponseGroup(responseGroupId));
                log.info("Running jobs completed for jobId:{}", (Object)request.getJobId());
            }
        }
        catch (Exception e) {
            log.error("Failed to run job - jobId:" + request.getJobId() + "for nodeId: " + this.getNodeId(), (Throwable)e);
            JobRunnerResponse.failed((Throwable)e);
        }
        return JobRunnerResponse.success((String)"");
    }

    private void executeMacroAssessment(BooleanSupplier isAssessmentCanceled, CpuStatsCalculator calculator) throws IOException {
        log.info("Macro assessment started");
        calculator.start();
        MacroAssessmentResult assessment = this.macroAssessmentService.assess(isAssessmentCanceled);
        CpuStatsCalculator.CpuStats cpuStats = calculator.finish();
        assessment.addExecutionStats(cpuStats.duration.toMillis(), cpuStats.load);
        log.info("Macro assessment finished, storing the results");
        this.macroAssessmentStore.store(assessment, LocalDate.now());
        log.info("Macro assessment stored");
    }

    public List<GuardrailsResponse> getExamples() {
        GuardrailsResponseGroup responseGroup = new GuardrailsResponseGroup("ID", this.getNodeId());
        return this.assessmentQueries.getQueries().stream().flatMap(q -> this.execute((AssessmentQuery)q, responseGroup, () -> false, AssessmentQuery::examples, CpuStatsCalculator.createCalculator())).collect(Collectors.toList());
    }

    private void executeGuardrailsQueries(GuardrailsResponseGroup responseGroup, BooleanSupplier cancelSupplier, CpuStatsCalculator cpuLoadBeforeAssessment) {
        this.assessmentQueries.getQueries().forEach(query -> {
            List guardrailsResponses = this.execute((AssessmentQuery)query, responseGroup, cancelSupplier, AssessmentQuery::executeAll, cpuLoadBeforeAssessment).collect(Collectors.toList());
            this.ptx.write(() -> guardrailsResponses.forEach(this.guardrailsResponseStore::createGuardrailsResponse));
        });
    }

    public Stream<GuardrailsResponse> execute(AssessmentQuery query, GuardrailsResponseGroup responseGroup, BooleanSupplier cancelSupplier, Function<AssessmentQuery, Map<QueryIds, QueryResult>> executor, CpuStatsCalculator cpuStatsCalculator) {
        InstanceAssessmentStatus status;
        GuardrailsResponse.GuardrailsResponseBuilder guardrailsResponse = GuardrailsResponse.builder().responseGroupId(responseGroup.getId()).responseGroup(responseGroup).guardrailsResponseType(GuardrailsResponseType.L1);
        Set<QueryIds> queryIds = query.queryIds();
        EnumMap results = new EnumMap(QueryIds.class);
        if (cancelSupplier.getAsBoolean()) {
            log.info("Query with queryId:{} canceled", queryIds);
            status = InstanceAssessmentStatus.CANCELED;
        } else if (this.assessmentQueries.shouldSkip(query)) {
            log.info("Skipping query with queryId:{}", queryIds);
            status = InstanceAssessmentStatus.SKIPPED;
        } else {
            cpuStatsCalculator.start();
            try {
                results.putAll(Maps.transformValues(executor.apply(query), QueryResult::generateResult));
                status = InstanceAssessmentStatus.COMPLETE;
                log.info("Finished executing query with queryId:{} for jobID:{} in :{}ms", new Object[]{queryIds, responseGroup.getJobId(), cpuStatsCalculator.duration().toMillis()});
            }
            catch (Exception e) {
                status = cpuStatsCalculator.duration().compareTo(AbstractQuery.QUERY_TIMEOUT) >= 0 ? InstanceAssessmentStatus.TIMED_OUT : InstanceAssessmentStatus.FAILED;
                log.error("Error while executing query for queryID: {} ", queryIds, (Object)e);
            }
            CpuStatsCalculator.CpuStats cpuStats = cpuStatsCalculator.finish();
            guardrailsResponse.queryCpuLoad(cpuStats.load);
            guardrailsResponse.queryDuration(cpuStats.duration.toMillis());
        }
        guardrailsResponse.queryStatus(status.toString());
        guardrailsResponse.success(status == InstanceAssessmentStatus.SKIPPED || status == InstanceAssessmentStatus.COMPLETE);
        return queryIds.stream().map(id -> guardrailsResponse.queryId(id.name()).queryResponse(results.getOrDefault(id, "")).build());
    }

    private String getNodeId() {
        return Optional.ofNullable(this.clusterInformationService.getCurrentNodeId()).orElse(DEFAULT_NODE);
    }

    public long getJobProgress(String jobId) {
        log.info("Job running for jobId:{}", (Object)jobId);
        int numberOfQueries = this.assessmentQueries.queriesCount();
        Long completedQueries = this.guardrailsResponseStore.getNumberOfQueries(jobId);
        log.info("Queries :{} is :{}", (Object)completedQueries, (Object)numberOfQueries);
        long progress = numberOfQueries == 0 ? 0L : completedQueries * 100L / (long)numberOfQueries;
        log.info("Progress for jobId:{} is :{}", (Object)jobId, (Object)progress);
        return progress;
    }

    public Set<JobDetails> getActiveJobs() {
        return Collections.unmodifiableSet(new HashSet(this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY)));
    }

    public void scheduleJob() throws SchedulerServiceException {
        JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withParameters(Collections.singletonMap(SERVER_NODE, this.getNodeId())).withSchedule(Schedule.runOnce(null)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER));
        log.info("Job scheduled with id:{} for  nodeId:{}", (Object)jobId, (Object)this.getNodeId());
    }

    private BooleanSupplier isCanceledSupplier(final String jobId) {
        return new BooleanSupplier(){
            boolean canceled = false;

            @Override
            public boolean getAsBoolean() {
                this.canceled = this.canceled || InstanceAssessmentService.this.isCanceled(jobId);
                return this.canceled;
            }
        };
    }

    private boolean isCanceled(String jobId) {
        try {
            GuardrailsResponseGroup responseGroup = this.guardRailsResponseGroupStore.getResponseGroupByJobId(jobId);
            return responseGroup != null && responseGroup.isCanceled();
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    public void cancelAssessmentCollection() {
        this.ptx.write(() -> {
            Optional<GuardrailsResponseGroup> lastJob = this.guardRailsResponseGroupStore.findLast();
            lastJob.ifPresent(job -> this.guardRailsResponseGroupStore.cancelGuardrails(job.getId()));
        });
        List jobDetails = this.schedulerService.getJobsByJobRunnerKey(RUNNER_KEY);
        jobDetails.stream().map(JobDetails::getJobId).forEach(arg_0 -> ((SchedulerService)this.schedulerService).unscheduleJob(arg_0));
        log.info("Instance assessment control is canceled.");
    }
}

