/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.service.catalogue.TransferStatusUpdateRequest;
import com.atlassian.migration.agent.service.prc.GenericPollerConfig;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.prc.PrcOkHttpAdapter;
import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.model.AttachmentMigrationPayload;
import com.atlassian.migration.agent.v4.model.ConfluenceSpaceExportPayload;
import com.atlassian.migration.agent.v4.model.ConfluenceSpaceUploadPayload;
import com.atlassian.migration.agent.v4.model.GlobalEntitiesMigrationPayload;
import com.atlassian.migration.agent.v4.model.MigrationPayload;
import com.atlassian.migration.agent.v4.model.UsersGroupsMigrationPayload;
import com.atlassian.migration.agent.v4.pollers.AbstractPoller;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.tasks.UsersGroupsUploadTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V4Poller<T extends TransferTask>
extends AbstractPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V4Poller.class);
    private final V4Worker<T> worker;
    private final PollerConfig config;
    private final OnDemandPrcPoller prcPoller;
    private InProgressMigrationIds migrationIds;
    private final PollerConfigHandler pollerConfigHandler;
    private final SystemInformationService systemInformationService;
    private final PrcOkHttpAdapter prcOkHttpAdapter;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public V4Poller(String pollerId, V4Worker<T> worker, PollerConfig config, OnDemandPrcPoller prcPoller, InProgressMigrationIds inProgressMigrationIds, PollerConfigHandler pollerConfigHandler, SystemInformationService systemInformationService, PrcOkHttpAdapter prcOkHttpAdapter, MigrationAgentConfiguration migrationAgentConfiguration) {
        super(pollerId, config.getPollingDelay());
        this.worker = worker;
        this.config = config;
        this.prcPoller = prcPoller;
        this.migrationIds = inProgressMigrationIds;
        this.pollerConfigHandler = pollerConfigHandler;
        this.systemInformationService = systemInformationService;
        this.prcOkHttpAdapter = prcOkHttpAdapter;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
    }

    @Override
    public boolean doPoll() {
        return this.migrationIds.sequence().filter(m -> MigrationProtocol.V4.equals((Object)m.getProtocol())).anyMatch(m -> this.pollForTaskAndDispatch(m.getCloudSite()));
    }

    private boolean pollForTaskAndDispatch(CloudSite cloudSite) {
        try {
            log.debug("Polling command for poller: {}", (Object)this.pollerId);
            OnDemandPollerConfig pollerConfig = this.buildPrcPollerConfig(cloudSite);
            Command command = this.prcPoller.pollAndDeliver(pollerConfig);
            if (command == null) {
                log.debug("No command received for poller {}. Will keep trying", (Object)this.pollerId);
                return true;
            }
            log.info("Command: {} received for poller {}", (Object)command.getId(), (Object)this.pollerId);
            return this.dispatchTask(cloudSite, command);
        }
        catch (Exception e) {
            log.warn("Poller {} failed with exception: {}, will try again", (Object)this.pollerId, (Object)e.toString());
            return true;
        }
    }

    public PrcTask toPrcTask(Command command, CloudSite cloudSite) {
        try {
            log.debug("Deserializing command payload for command name : {} and id : {}", (Object)command.getName(), (Object)command.getId());
            MigrationPayload payload = (MigrationPayload)OBJECT_MAPPER.readValue(command.getPayload(), this.getMigrationPayloadType(command.getName()));
            return this.getMigrationTask(command, payload, cloudSite);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private Class<? extends MigrationPayload> getMigrationPayloadType(String commandName) {
        if (Objects.equals(commandName, CommandName.ALL_USER_UPLOAD.getValue())) {
            return UsersGroupsMigrationPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_ATTACHMENT_UPLOAD.getValue())) {
            return AttachmentMigrationPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_SPACE_EXPORT.getValue())) {
            return ConfluenceSpaceExportPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_SPACE_UPLOAD.getValue())) {
            return ConfluenceSpaceUploadPayload.class;
        }
        if (Objects.equals(commandName, CommandName.GLOBAL_ENTITIES_UPLOAD.getValue())) {
            return GlobalEntitiesMigrationPayload.class;
        }
        throw new IllegalArgumentException("Invalid command " + commandName + " supplied for payload conversion");
    }

    private PrcTask<UsersGroupsUploadTask> getUsersGroupsMigrationTask(Command command, UsersGroupsMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<UsersGroupsUploadTask> prcTask = new PrcTask<UsersGroupsUploadTask>();
        prcTask.setTransferTask(new UsersGroupsUploadTask(payload.getSourceCommandId()));
        prcTask.setCommandName(CommandName.ALL_USER_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<AttachmentUploadTransferTask> getAttachmentUploadTransferTask(Command command, AttachmentMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<AttachmentUploadTransferTask> prcTask = new PrcTask<AttachmentUploadTransferTask>();
        prcTask.setTransferTask(new AttachmentUploadTransferTask(payload.getSourceCommandId(), payload.getSourceId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_ATTACHMENT_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<SpaceExportTransferTask> getSpaceExportTransferTask(Command command, ConfluenceSpaceExportPayload payload, CloudSite cloudsite) {
        PrcTask<SpaceExportTransferTask> prcTask = new PrcTask<SpaceExportTransferTask>();
        prcTask.setTransferTask(new SpaceExportTransferTask(payload.getSourceCommandId(), payload.getSourceId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_SPACE_EXPORT);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<SpaceUploadTransferTask> getSpaceUploadTransferTask(Command command, ConfluenceSpaceUploadPayload payload, CloudSite cloudsite) {
        PrcTask<SpaceUploadTransferTask> prcTask = new PrcTask<SpaceUploadTransferTask>();
        prcTask.setTransferTask(new SpaceUploadTransferTask(payload.getSourceCommandId(), payload.getSourceId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_SPACE_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<GlobalEntitiesTransferTask> getGlobalEntitiesTransferTask(Command command, GlobalEntitiesMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<GlobalEntitiesTransferTask> prcTask = new PrcTask<GlobalEntitiesTransferTask>();
        prcTask.setTransferTask(new GlobalEntitiesTransferTask(payload.getSourceCommandId()));
        prcTask.setCommandName(CommandName.GLOBAL_ENTITIES_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private void setPrcTaskFields(PrcTask prcTask, Command command, MigrationPayload payload, CloudSite cloudsite) {
        prcTask.setPrcCommandId(command.getId());
        prcTask.setMigrationId(payload.getMigration().getId());
        prcTask.setCommandSource(payload.getCommandSource());
        prcTask.setChannelName(this.getChannelName());
        prcTask.setCommand(command);
        prcTask.setCloudSite(cloudsite);
        prcTask.setOriginalPlanId(payload.getMigration().getOriginalPlanId());
        GenericPollerConfig genericPollerConfig = new GenericPollerConfig(prcTask.getChannelName(), prcTask.getCloudSite().getCloudId(), prcTask.getCloudSite().getContainerToken(), this.prcOkHttpAdapter, this.migrationAgentConfiguration.getPrcHostUrl(), Collections.singletonList(prcTask.getCommandName().getValue()));
        prcTask.setGenericPollerConfig(genericPollerConfig);
    }

    private PrcTask getMigrationTask(Command command, MigrationPayload payload, CloudSite cloudsite) {
        if (command.getName().equals(CommandName.ALL_USER_UPLOAD.getValue())) {
            return this.getUsersGroupsMigrationTask(command, (UsersGroupsMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_ATTACHMENT_UPLOAD.getValue())) {
            return this.getAttachmentUploadTransferTask(command, (AttachmentMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.GLOBAL_ENTITIES_UPLOAD.getValue())) {
            return this.getGlobalEntitiesTransferTask(command, (GlobalEntitiesMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_SPACE_EXPORT.getValue())) {
            return this.getSpaceExportTransferTask(command, (ConfluenceSpaceExportPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_SPACE_UPLOAD.getValue())) {
            return this.getSpaceUploadTransferTask(command, (ConfluenceSpaceUploadPayload)payload, cloudsite);
        }
        throw new IllegalArgumentException("Invalid command name supplied for payload conversion");
    }

    private boolean dispatchTask(CloudSite cloudsite, Command command) {
        PrcTask task = this.toPrcTask(command, cloudsite);
        try {
            this.worker.process(task, this.prcPoller, this.pollerConfigHandler);
            return true;
        }
        catch (Exception e) {
            log.error("{}: task worker failed to process. Exception: {}", (Object)this.worker.getId(), (Object)e.toString());
            log.error("Marking task as failed in PRC");
            this.reportFailureToPRC(cloudsite.getCloudId(), task, e);
            return false;
        }
    }

    private String getChannelName() {
        return "confluence-server-to-cloud-" + this.systemInformationService.getConfluenceInfo().getServerId();
    }

    public OnDemandPollerConfig buildPrcPollerConfig(CloudSite cloudSite) {
        return this.pollerConfigHandler.getOnDemandPollerConfigWithCallbacks(this.getChannelName(), cloudSite.getCloudId(), cloudSite.getContainerToken(), Collections.singletonList(this.worker.getCommandName().getValue()));
    }

    private void reportFailureToPRC(String cloudId, PrcTask<T> task, Throwable e) {
        try {
            log.info(" Update failure result to PRC for the {}", (Object)cloudId);
            OnDemandPollerConfig pollerConfig = this.buildPrcPollerConfig(task.getCloudSite());
            TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.FAILED, e.getMessage());
            ObjectMapper map = new ObjectMapper();
            JsonNode payload = (JsonNode)map.convertValue((Object)transferStatusUpdateRequest, JsonNode.class);
            payload = map.createObjectNode().set("migration", payload);
            CommandStatusRequest commandStatusRequest = new CommandStatusRequest(task.getCommandSource(), CommandStatus.FAILED, ((TransferTask)task.getTransferTask()).getTaskId(), payload);
            this.prcPoller.sendCommandCompletionStatus(pollerConfig, task.getPrcCommandId().longValue(), commandStatusRequest);
        }
        catch (RuntimeException r) {
            log.error("${}: failed to update task status in PRC for command: {} {} {} ", new Object[]{this.worker.getId(), task.getPrcCommandId(), r, e.toString()});
        }
    }

    @Generated
    public V4Worker<T> getWorker() {
        return this.worker;
    }
}

