/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics.builders;

import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.DatabaseInfo;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.model.stats.GlobalEntitiesStats;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.analytics.ProgressStatus;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;

public class AnalyticsEventBuilderUtil {
    private static final Logger log = ContextLoggerFactory.getLogger(AnalyticsEventBuilderUtil.class);
    private final PluginVersionManager pluginVersionManager;
    private final SystemInformationService systemInformationService;
    private final Supplier<Instant> instantSupplier;
    private final SENSupplier senSupplier;
    private final LicenseHandler licenseHandler;
    private final StatisticsService statisticsService;
    private final SpaceManager spaceManager;

    public AnalyticsEventBuilderUtil(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, SENSupplier senSupplier, LicenseHandler licenseHandler, StatisticsService statisticsService, SpaceManager spaceManager) {
        this(pluginVersionManager, systemInformationService, Instant::now, senSupplier, licenseHandler, statisticsService, spaceManager);
    }

    @VisibleForTesting
    AnalyticsEventBuilderUtil(PluginVersionManager pluginVersionManager, SystemInformationService systemInformationService, Supplier<Instant> instantSupplier, SENSupplier senSupplier, LicenseHandler licenseHandler, StatisticsService statisticsService, SpaceManager spaceManager) {
        this.pluginVersionManager = pluginVersionManager;
        this.systemInformationService = systemInformationService;
        this.instantSupplier = instantSupplier;
        this.senSupplier = senSupplier;
        this.licenseHandler = licenseHandler;
        this.statisticsService = statisticsService;
        this.spaceManager = spaceManager;
    }

    Map<String, Object> addCommonFrontendAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> map = new HashMap<String, Object>(attributes);
        map.put("pluginVersion", this.pluginVersionManager.getPluginVersion());
        map.put("isInternalContext", this.pluginVersionManager.isTestVersion() != false || this.isInternalSen() != false);
        return map;
    }

    Map<String, Object> mapServerInformationAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serverId", this.licenseHandler.getServerId());
        map.put("licenseMaxUsersCount", Optional.ofNullable(this.licenseHandler.getProductLicenseDetails("conf")).flatMap(confluence -> Optional.of(confluence.getNumberOfUsers())).orElse(null));
        return map;
    }

    Map<String, String> buildCounterMetricCommonTags() {
        HashMap<String, String> commonTagsMap = new HashMap<String, String>();
        commonTagsMap.put("productFamily", "confluence");
        commonTagsMap.put("migrationType", "S2C_MIGRATION");
        commonTagsMap.put("product", "confluence");
        commonTagsMap.put("version", this.pluginVersionManager.getPluginVersion());
        commonTagsMap.put("isInternalSen", this.isInternalSenStr());
        return commonTagsMap;
    }

    Map<String, String> buildPlatformCounterMetricCommonTags(ExecutionStatus status, MigrationTag migrationTag) {
        HashMap<String, String> commonTagsMap = new HashMap<String, String>();
        commonTagsMap.put("status", this.convertToProgressStatus(status).getStatusName());
        commonTagsMap.put("isInternalSen", this.isInternalSenStr());
        commonTagsMap.put("migrationTag", migrationTag.name());
        return commonTagsMap;
    }

    void addConfluenceAndDBVersionInAttributes(ImmutableMap.Builder<String, Object> attributes) {
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)"type", (Object)databaseInfo.getName(), (Object)"version", (Object)databaseInfo.getVersion()));
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        attributes.put((Object)"confluenceVersion", (Object)confluenceInfo.getVersion());
    }

    String getValueFromEventAttributesMap(Map<String, String> eventAttributesMap, String key) {
        if (eventAttributesMap != null) {
            return eventAttributesMap.getOrDefault(key, "Unknown");
        }
        return "Unknown";
    }

    GenericOperationalEvent.Builder getBuilderStartedEvent(Step step, long startTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderStepAnalyticsEvent(step, startTime);
        return (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.instantSupplier.get().toEpochMilli()).action("started")).sen(this.senSupplier.get())).actionSubject("step", step.getId())).contextContainer("plan", step.getPlan().getId())).withAttributes((Map)attributes.build());
    }

    ImmutableMap.Builder<String, Object> getBuilderStepAnalyticsEvent(Step step, long startTime) {
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"stepType", (Object)step.getType());
        attributes.put((Object)"taskId", (Object)step.getTask().getId());
        attributes.put((Object)"migrationId", (Object)step.getPlan().getMigrationId());
        attributes.put((Object)"startTime", (Object)startTime);
        attributes.put((Object)"platformVersion", (Object)step.getPlan().getMigrationProtocol().name());
        return attributes;
    }

    ImmutableMap.Builder<String, Object> getSpaceStatisticBuilderWithCommonAttributes() {
        DatabaseInfo databaseInfo = this.systemInformationService.getDatabaseInfo();
        ImmutableMap.Builder<String, Object> attributes = this.getBuilderWithCommonAttributes();
        attributes.put((Object)"database", (Object)ImmutableMap.of((Object)"type", (Object)databaseInfo.getName(), (Object)"version", (Object)databaseInfo.getVersion()));
        attributes.put((Object)"pluginVersion", (Object)this.pluginVersionManager.getPluginVersion());
        attributes.put((Object)"confluenceVersion", (Object)this.systemInformationService.getConfluenceInfo().getVersion());
        return attributes;
    }

    ImmutableMap.Builder<String, Object> getBuilderWithCommonAttributes() {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        attributes.put((Object)"productFamily", (Object)"confluence");
        attributes.put((Object)"migrationType", (Object)"S2C_MIGRATION");
        return attributes;
    }

    ProgressStatus convertToProgressStatus(ExecutionStatus execStatus) {
        switch (execStatus) {
            case DONE: {
                return ProgressStatus.SUCCESS;
            }
            case FAILED: {
                return ProgressStatus.FAILED;
            }
            case STOPPED: {
                return ProgressStatus.CANCELLED;
            }
            case INCOMPLETE: 
            case CREATED: 
            case VALIDATING: 
            case RUNNING: 
            case STOPPING: {
                return ProgressStatus.INCOMPLETE;
            }
        }
        throw new IllegalArgumentException("Unknown execution status " + execStatus.name());
    }

    private Boolean isInternalSen() {
        String sen = this.senSupplier.get();
        return StringUtils.isEmpty((String)sen) || sen.equals("SEN-500");
    }

    String isInternalSenStr() {
        return Boolean.toString(this.isInternalSen());
    }

    void feedSpaceIdIfPresent(String spaceKey, LongConsumer spaceIdConsumer) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (Objects.nonNull(space)) {
            spaceIdConsumer.accept(space.getId());
        }
    }

    void feedSpaceStatsIfPresent(String spaceKey, Consumer<SpaceStats> spaceStatsConsumer) {
        try {
            SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(spaceKey);
            if (Objects.nonNull(spaceStats)) {
                spaceStatsConsumer.accept(spaceStats);
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve space stats: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    void feedSpaceStatsCollectionIfPresent(List<String> spaceKeys, Consumer<Collection<SpaceStats>> spaceStatsCollectionConsumer) {
        try {
            Collection<SpaceStats> spaceStatsCollection = this.statisticsService.loadSpaceStatistics(spaceKeys);
            if (Objects.nonNull(spaceStatsCollection)) {
                spaceStatsCollectionConsumer.accept(spaceStatsCollection);
            }
        }
        catch (Exception e) {
            log.error("Unable to retrieve space stats collections: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @NotNull
    ImmutableMap.Builder<String, Object> getSourceDestinationLocation(String cloudId) {
        ImmutableMap.Builder attributes = new ImmutableMap.Builder();
        HashMap<String, String> sourceLocation = new HashMap<String, String>();
        sourceLocation.put("serverId", this.licenseHandler.getServerId());
        sourceLocation.put("confluenceSen", this.senSupplier.get());
        attributes.put((Object)"sourceLocation", sourceLocation);
        HashMap<String, String> destinationLocation = new HashMap<String, String>();
        destinationLocation.put("cloudId", cloudId);
        attributes.put((Object)"destinationLocation", destinationLocation);
        return attributes;
    }

    void addGlobalEntitiesStatsToAttributes(ImmutableMap.Builder<String, Object> attributes, GlobalEntitiesStats globalEntitiesStats) {
        attributes.put((Object)"totalGlobalPageTemplates", (Object)Long.toString(globalEntitiesStats.getNumberOfGlobalPageTemplates()));
        attributes.put((Object)"totalCustomSystemTemplates", (Object)Long.toString(globalEntitiesStats.getNumberOfEditedSystemTemplates()));
    }

    Map<String, Object> buildTableExportedToCSVTimerEvent(String tableName, String query, String dbType, long timeToFirstRecord, long rowsExported, long charactersExported) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("tableName", tableName);
        attributes.put("timeToFirstRecord", timeToFirstRecord);
        attributes.put("rowsExported", rowsExported);
        attributes.put("charactersExported", charactersExported);
        attributes.put("exportQueryHash", DigestUtils.sha256Hex((String)query));
        attributes.put("dbType", dbType);
        return attributes;
    }
}

