/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mapi.executor;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.MapiArtifacts;
import com.atlassian.migration.agent.entity.MapiArtifactsId;
import com.atlassian.migration.agent.entity.MapiTaskMapping;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.mapi.entity.MapiCheckDetailsDto;
import com.atlassian.migration.agent.mapi.entity.MapiOutcome;
import com.atlassian.migration.agent.mapi.entity.MapiStatus;
import com.atlassian.migration.agent.mapi.entity.MapiStatusDto;
import com.atlassian.migration.agent.mapi.external.MapiMigrationService;
import com.atlassian.migration.agent.mapi.external.model.ArtifactResponse;
import com.atlassian.migration.agent.mapi.external.model.McsMigrationScopeArtifactIdentifiers;
import com.atlassian.migration.agent.mapi.external.model.UpdateArtifactRequest;
import com.atlassian.migration.agent.okhttp.HttpException;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.model.MigrationCatalogueStorageFile;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.FailedChecksFileReportsManager;
import com.atlassian.migration.agent.service.impl.MapiArtifactsService;
import com.atlassian.migration.agent.service.prc.model.CommandName;
import com.atlassian.migration.agent.store.PlanStore;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapiFailedPreFlightChecksService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapiFailedPreFlightChecksService.class);
    private static final BiPredicate<MapiStatus, MapiOutcome> IS_CHECK_STATUS_FAILED = (status, outcome) -> MapiStatus.FINISHED.equals(status) && MapiOutcome.FAILED.equals(outcome);
    private static final Predicate<String> isValidCommand = command -> CommandName.IS_CHECK_COMMAND.test((String)command) || CommandName.IS_MIGRATE_COMMAND.test((String)command);
    private final MigrationCatalogueStorageService migrationCatalogueStorageService;
    private final PlatformService platformService;
    private final FailedChecksFileReportsManager failedChecksFileReportsManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final MapiMigrationService mapiMigrationService;
    private final MapiArtifactsService mapiArtifactsService;
    private final PlanStore planStore;

    public MapiFailedPreFlightChecksService(MigrationCatalogueStorageService migrationCatalogueStorageService, PlatformService platformService, FailedChecksFileReportsManager failedChecksFileReportsManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MapiMigrationService mapiMigrationService, MapiArtifactsService mapiArtifactsService, PlanStore planStore) {
        this.migrationCatalogueStorageService = migrationCatalogueStorageService;
        this.platformService = platformService;
        this.failedChecksFileReportsManager = failedChecksFileReportsManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.mapiMigrationService = mapiMigrationService;
        this.mapiArtifactsService = mapiArtifactsService;
        this.planStore = planStore;
    }

    public void addFilesToFailedPreflightChecks(MapiTaskMapping mapiTaskMapping, List<MapiStatusDto> mapiStatusDtoList) {
        Plan plan = this.planStore.getPlan(mapiTaskMapping.getPlanId());
        if (!this.canAddFilesToFailedPreflightChecks(plan, mapiTaskMapping.getCommandName())) {
            return;
        }
        mapiStatusDtoList.stream().filter(dto -> IS_CHECK_STATUS_FAILED.test(dto.getStatus(), dto.getOutcome())).forEach(dto -> this.processFailedCheck(mapiTaskMapping.getJobId(), mapiTaskMapping.getTaskId(), mapiTaskMapping.getCloudId(), (MapiStatusDto)dto));
    }

    private boolean canAddFilesToFailedPreflightChecks(Plan plan, String commandName) {
        return this.migrationDarkFeaturesManager.enableFileDownloadForMapiPreFlightChecks(plan) && isValidCommand.test(commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processFailedCheck(String jobId, String executionId, String cloudId, MapiStatusDto mapiStatusDto) {
        File csvFileForFailedCheck;
        block7: {
            csvFileForFailedCheck = null;
            CheckType checkType = this.failedChecksFileReportsManager.getCheckType(mapiStatusDto);
            csvFileForFailedCheck = this.failedChecksFileReportsManager.createCSVFileForFailedCheck(executionId, checkType);
            if (csvFileForFailedCheck != null && !this.isArtifactAlreadyUpdated(executionId, checkType.value())) break block7;
            this.failedChecksFileReportsManager.deleteTemporaryFile(csvFileForFailedCheck);
            return;
        }
        try {
            Optional<CloudSite> cloudSite = this.mapiMigrationService.getCloudSite(cloudId);
            File finalCsvFileForFailedCheck = csvFileForFailedCheck;
            cloudSite.ifPresent(site -> this.handleFileUploadAndUpdate(jobId, executionId, cloudId, mapiStatusDto, finalCsvFileForFailedCheck, (CloudSite)site));
        }
        catch (HttpException e) {
            log.error("An error occurred when creating migration scope id for cloudId: {}", (Object)cloudId, (Object)e);
            this.failedChecksFileReportsManager.deleteTemporaryFile(csvFileForFailedCheck);
        }
        catch (Exception e2) {
            log.error("Error while creating the CSV file for failed checks and updating to migration details for taskId: {}", (Object)executionId, (Object)e2);
            this.failedChecksFileReportsManager.deleteTemporaryFile(csvFileForFailedCheck);
            {
                catch (Throwable throwable) {
                    this.failedChecksFileReportsManager.deleteTemporaryFile(csvFileForFailedCheck);
                    throw throwable;
                }
            }
        }
        this.failedChecksFileReportsManager.deleteTemporaryFile(csvFileForFailedCheck);
    }

    private void handleFileUploadAndUpdate(String jobId, String executionId, String cloudId, MapiStatusDto mapiStatusDto, File csvFileForFailedCheck, CloudSite cloudSite) {
        String migrationScopeId = this.platformService.getCachedOrCreateMigrationScopeId(cloudSite);
        MigrationCatalogueStorageFile migrationCatalogueStorageFile = this.migrationCatalogueStorageService.uploadFileToMCSByMigrationScopeId(cloudId, migrationScopeId, csvFileForFailedCheck.toPath());
        this.updateFileDetailsInMapi(jobId, executionId, cloudId, migrationScopeId, migrationCatalogueStorageFile, mapiStatusDto);
    }

    private void updateFileDetailsInMapi(String jobId, String taskId, String cloudId, String migrationScopeId, MigrationCatalogueStorageFile migrationCatalogueStorageFile, MapiStatusDto mapiStatusDto) {
        McsMigrationScopeArtifactIdentifiers artifactIdentifiers = new McsMigrationScopeArtifactIdentifiers(migrationScopeId, migrationCatalogueStorageFile.getFileId());
        UpdateArtifactRequest artifactRequest = new UpdateArtifactRequest(migrationCatalogueStorageFile.getName(), UpdateArtifactRequest.ArtifactSource.MCS_MIGRATION_SCOPE.name(), artifactIdentifiers);
        ArtifactResponse artifactResponse = this.mapiMigrationService.sendArtifactsToMapi(jobId, taskId, cloudId, artifactRequest);
        this.updateArtifactDetails(mapiStatusDto.getDetails(), artifactResponse, mapiStatusDto);
        CheckType checkType = this.failedChecksFileReportsManager.getCheckType(mapiStatusDto);
        this.updateArtifactTable(taskId, checkType.value(), artifactResponse.getName());
    }

    private void updateArtifactDetails(MapiCheckDetailsDto details, ArtifactResponse artifactResponse, MapiStatusDto mapiStatusDto) {
        if (details == null) {
            details = new MapiCheckDetailsDto();
        }
        if (details.getArtifactDetails() == null) {
            details.setArtifactDetails(new ArrayList<ArtifactResponse>());
        }
        details.getArtifactDetails().add(artifactResponse);
        mapiStatusDto.setDetails(details);
    }

    public boolean isArtifactAlreadyUpdated(String taskId, String checkName) {
        Optional<MapiArtifacts> artifact = this.mapiArtifactsService.getArtifact(taskId, checkName);
        return artifact.isPresent();
    }

    private void updateArtifactTable(String taskId, String checkName, String artifactName) {
        MapiArtifactsId mapiArtifactsId = new MapiArtifactsId(taskId, checkName);
        MapiArtifacts mapiArtifacts = new MapiArtifacts(mapiArtifactsId, artifactName, Instant.now());
        this.mapiArtifactsService.saveOrUpdate(mapiArtifacts);
    }

    public void deleteAllArtifactForTask(String taskId, MapiStatusDto mapiStatusDto) {
        if (IS_CHECK_STATUS_FAILED.test(mapiStatusDto.getStatus(), mapiStatusDto.getOutcome())) {
            this.mapiArtifactsService.deleteArtifactByTaskId(taskId);
        }
    }
}

