/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.migration.agent.dto.GlobalEntitiesExportStepConfig;
import com.atlassian.migration.agent.entity.MigrateGlobalEntitiesTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.globalentities.V4GlobalEntitiesUploadExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.GlobalEntitiesUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.UUID;

public class GlobalEntitiesUploadWorker
extends V4Worker<GlobalEntitiesTransferTask> {
    private V4GlobalEntitiesUploadExecutor v4GlobalEntitiesUploadExecutor;
    private PrcTask<GlobalEntitiesTransferTask> prcTask;

    public GlobalEntitiesUploadWorker(List<ProgressUnit> supportedUnits, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, V4GlobalEntitiesUploadExecutor v4GlobalEntitiesUploadExecutor, MigrationLogService migrationLogService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.commandName = CommandName.GLOBAL_ENTITIES_UPLOAD;
        this.v4GlobalEntitiesUploadExecutor = v4GlobalEntitiesUploadExecutor;
    }

    @Override
    public void process(PrcTask<GlobalEntitiesTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        this.prcTask = prcTask;
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.GLOBAL_ENTITIES_DATA_UPLOAD.name());
        prcStep.setSubType(StepSubType.GLOBAL_ENTITIES_EXPORT.name());
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        GlobalEntitiesUploadProcessor processor = new GlobalEntitiesUploadProcessor(prcTask, this.v4GlobalEntitiesUploadExecutor, prcPoller, pollerConfigHandler, prcStep, this.migrationLogService);
        processor.initiate();
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<GlobalEntitiesTransferTask> prcTask) {
        return tasks.stream().filter(MigrateGlobalEntitiesTask.class::isInstance).map(MigrateGlobalEntitiesTask.class::cast).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        String cloudId = this.prcTask.getCloudSite().getCloudId();
        step.setConfig(Jsons.valueAsString(new GlobalEntitiesExportStepConfig(UUID.randomUUID().toString(), cloudId)));
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.GLOBAL_ENTITIES_UPLOAD;
    }
}

