WRM.require("wr!external-libraries").done(function () {
  function checkBrowserMetricsEnabled(callback) {
    AJS.log("Checking if browser metrics is enabled.");
    const request = AJS.$.ajax({
      url: AJS.contextPath() + "/rest/migration/latest/browser-metrics/enabled",
      type: "GET",
    });

    request.done(function (data) {
      callback(data && data.shouldCollect);
    });
    request.fail(function () {
      AJS.log("Ajax error response: " + request.statusText);
    });
  }

  // see https://developer.atlassian.com/server/jira/platform/jira-rest-api-examples/#calling-the-rest-api-from-an-app--quickview-inline-dialog-app
  AJS.toInit(function () {
    setTimeout(function () {
      // Delay of 3s to avoid impacting conf page load performance
      checkBrowserMetricsEnabled(function (isBrowserMetricsEnabled) {
        if (isBrowserMetricsEnabled) {
          AJS.log("Collecting browser metrics data.");
          const connection = window.navigator.connection || {};
          const networkTelemetry = connection
            ? {
                effectiveType: connection.effectiveType,
                downlink: Number(connection.downlink),
                rtt: Number(connection.rtt),
              }
            : null;
          const browser = bowser.getParser(window.navigator.userAgent);
          const payload = {
            browserName: browser.getBrowserName(),
            browserVersion: browser.getBrowserVersion(),
            platform: window.navigator.platform,
            device: {
              processors: window.navigator.hardwareConcurrency,
              memory: window.navigator.deviceMemory,
            },
            network: networkTelemetry,
          };
  
          const request = AJS.$.ajax({
            url: AJS.contextPath() + "/rest/migration/latest/browser-metrics",
            type: "POST",
            data: JSON.stringify(payload),
            dataType: "json",
            contentType: "application/json",
          });
  
          request.done(function () {
            AJS.log("Browser metrics data sent successfully");
          });
  
          request.fail(function () {
            AJS.log(
              `Error while sending browser metrics data: ${error.statusText}; With status: ${error.status}`
            );
          });
        } else {
          AJS.log(
            "Browser metrics is disabled or it was collected in the last 24h already."
          );
        }
      });
    }, 3000);
  });
});
