/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import com.atlassian.migration.agent.store.guardrails.queries.membership.MembershipFetcher;
import com.atlassian.migration.agent.store.guardrails.queries.membership.RawMembershipCounts;
import java.util.HashSet;
import java.util.Set;

class DirectoryData {
    final int[][] groupParents;
    final RawMembershipCounts users;
    final RawMembershipCounts groups;
    final int[] queue;

    DirectoryData(int[][] groupParents, RawMembershipCounts users, RawMembershipCounts groups) {
        this.groupParents = groupParents;
        this.users = users;
        this.groups = groups;
        this.queue = new int[groups.ids.length];
    }

    void addUserGroups(long[][] parents) {
        int i = 0;
        while (i < parents.length) {
            int next2 = MembershipFetcher.getNext(parents, i);
            int usersIndex = this.users.getIndex(parents[i][0]);
            if (usersIndex >= 0) {
                this.addUserGroups(usersIndex, MembershipFetcher.extract(parents, i, next2, this.groups));
            }
            i = next2;
        }
    }

    void addUserGroups(int userIdx, int[] userGroups) {
        HashSet<Integer> processed = new HashSet<Integer>();
        int qLen = this.addToQueue(0, userGroups, processed);
        for (int i = 0; i < qLen; ++i) {
            int groupIdx;
            int n = groupIdx = this.queue[i];
            this.groups.counts[n] = this.groups.counts[n] + 1L;
            qLen = this.addToQueue(qLen, this.groupParents[groupIdx], processed);
        }
        this.users.counts[userIdx] = qLen;
    }

    private int addToQueue(int pos, int[] groups, Set<Integer> processed) {
        for (int group : groups) {
            if (!processed.add(group)) continue;
            this.queue[pos++] = group;
        }
        return pos;
    }

    public String toString() {
        return "users: " + this.users + "\ngroups: " + this.groups;
    }
}

