/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.external;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.guardrails.external.BubblesExternalJobExampleResult;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJob;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import com.atlassian.migration.agent.service.portfolioanalyzer.model.SpaceRelationsGraph;
import com.atlassian.migration.agent.service.portfolioanalyzer.service.RelationsAnalyzerRunner;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class BubblesExternalJob
implements ExternalJob {
    private final RelationsAnalyzerRunner relationsAnalyzerRunner;
    private final Path outputFilesDirectory;
    private final SpaceRelationsGraph example;

    public BubblesExternalJob(RelationsAnalyzerRunner relationsAnalyzerRunner, Path outputFilesDir, SystemInformationService systemInformationService) {
        this.relationsAnalyzerRunner = relationsAnalyzerRunner;
        this.outputFilesDirectory = outputFilesDir;
        this.example = BubblesExternalJobExampleResult.buildExample(systemInformationService);
    }

    @Override
    public String name() {
        return "Confluence portfolio";
    }

    @Override
    public void start() {
        this.relationsAnalyzerRunner.scheduleJob();
    }

    @Override
    public void stop() {
    }

    @Override
    public ExternalJob.ExternalJobStatus getStatus() {
        return this.mapStatus(this.relationsAnalyzerRunner.getJobStatus());
    }

    private ExternalJob.ExternalJobStatus mapStatus(RelationsAnalyzerRunner.Status status) {
        if (status == RelationsAnalyzerRunner.Status.COMPLETED) {
            return ExternalJob.ExternalJobStatus.COMPLETED;
        }
        if (status == RelationsAnalyzerRunner.Status.IN_PROGRESS) {
            return ExternalJob.ExternalJobStatus.IN_PROGRESS;
        }
        if (status == RelationsAnalyzerRunner.Status.ERROR) {
            return ExternalJob.ExternalJobStatus.ERROR;
        }
        return ExternalJob.ExternalJobStatus.UNKNOWN;
    }

    @Override
    public Set<Path> getOutputFiles(String formattedDate) {
        RelationsAnalyzerRunner.Config config = this.relationsAnalyzerRunner.getConfig();
        return Stream.of(this.maybeMakeCopy(config.getJsonFilePath(), String.format("confluence-portfolio-results-%s.json", formattedDate)), this.maybeMakeCopy(config.getWarnFilePath(), String.format("confluence-portfolio-warn-%s.log", formattedDate)), this.maybeMakeCopy(config.getErrorFilePath(), String.format("confluence-portfolio-error-%s.log", formattedDate))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<Path> getExampleOutputFiles(String formattedDate) {
        Path resultFile = this.outputFilesDirectory.resolve(String.format("confluence-portfolio-results-%s.json", formattedDate));
        Path warnFile = this.outputFilesDirectory.resolve(String.format("confluence-portfolio-warn-%s.log", formattedDate));
        try {
            SerializationUtil.saveJson(resultFile.toFile(), this.example);
            Files.write(warnFile, BubblesExternalJobExampleResult.EXAMPLE_WARN, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ImmutableSet.of((Object)resultFile, (Object)warnFile);
    }

    private Path maybeMakeCopy(Path original, String copyFilename) {
        if (!Files.exists(original, new LinkOption[0])) {
            return null;
        }
        Path copyFilePath = this.outputFilesDirectory.resolve(copyFilename);
        try {
            FileUtils.copyFile((File)original.toFile(), (File)copyFilePath.toFile());
            return copyFilePath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Instant getCompletedTimestamp() {
        return this.relationsAnalyzerRunner.getCompletedTimestamp();
    }
}

