/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status.converter;

import com.atlassian.migration.agent.entity.TaskType;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import com.atlassian.migration.agent.service.catalogue.model.SiteContainer;
import com.atlassian.migration.agent.v4.pollers.status.converter.ContainerProgressConverter;
import com.atlassian.migration.agent.v4.pollers.status.converter.OperationKey;
import com.atlassian.migration.agent.v4.pollers.status.converter.TransferProgressConverter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ContainerProgressConverterFactory {
    private static final Map<OperationKey, TransferProgressConverter<ConfluenceSpaceContainer>> CONFLUENCE_ORDERED_TRANSFER_CONVERTER_MAP = ImmutableMap.of((Object)((Object)OperationKey.confluenceAttachmentUpload), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> ContainerProgressConverterFactory.isAttachmentUploadOnly(confluenceSpaceContainer) ? 100 : 30, "Attachment upload started", "Attachments uploaded successfully"), (Object)((Object)OperationKey.confluenceSpaceExport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 60, "Data export started", "Data exported successfully"), (Object)((Object)OperationKey.allUserImport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 65, "User import started", "Migrated Users successfully"), (Object)((Object)OperationKey.confluenceSpaceUpload), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 80, "Space data upload started", "Space data uploaded successfully"), (Object)((Object)OperationKey.confluenceImport), new TransferProgressConverter<ConfluenceSpaceContainer>(confluenceSpaceContainer -> 100, "Space import started", "Space imported successfully"));
    private static final ContainerProgressConverter<ConfluenceSpaceContainer> CONFLUENCE_SPACE_PROGRESS_CONVERTER = new ContainerProgressConverter(CONFLUENCE_ORDERED_TRANSFER_CONVERTER_MAP);
    private static final Map<OperationKey, TransferProgressConverter<SiteContainer>> USER_AND_GROUP_ORDERED_TRANSFER_CONVERTER_MAP = ImmutableMap.of((Object)((Object)OperationKey.allUserUpload), new TransferProgressConverter<SiteContainer>(siteContainer -> 50, "Users and groups export started", "Users and groups uploaded successfully"), (Object)((Object)OperationKey.allUserImport), new TransferProgressConverter<SiteContainer>(siteContainer -> 100, "Users and groups import started", "Users and groups imported successfully"));
    private static final ContainerProgressConverter<SiteContainer> USER_AND_GROUP_PROGRESS_CONVERTER = new ContainerProgressConverter(USER_AND_GROUP_ORDERED_TRANSFER_CONVERTER_MAP);
    private static final Map<OperationKey, TransferProgressConverter<SiteContainer>> GLOBAL_ENTITY_ORDERED_TRANSFER_CONVERTER_MAP = ImmutableMap.of((Object)((Object)OperationKey.globalEntitiesUpload), new TransferProgressConverter<SiteContainer>(siteContainer -> 50, "Global templates export started", "Global templates uploaded successfully"), (Object)((Object)OperationKey.confluencePostSpaceImport), new TransferProgressConverter<SiteContainer>(siteContainer -> 100, "Global templates import started", "Global templates imported successfully"));
    private static final ContainerProgressConverter<SiteContainer> GLOBAL_ENTITY_ORDERED_TRANSFER_CONVERTER = new ContainerProgressConverter(GLOBAL_ENTITY_ORDERED_TRANSFER_CONVERTER_MAP);

    public static ContainerProgressConverter<?> getContainerProgressConvertor(AbstractContainer.ContainerType type, TaskType taskType) {
        ContainerProgressConverter<AbstractContainer> result;
        switch (type) {
            case ConfluenceSpace: {
                result = CONFLUENCE_SPACE_PROGRESS_CONVERTER;
                break;
            }
            case Site: {
                if (taskType == TaskType.GLOBAL_ENTITIES) {
                    result = GLOBAL_ENTITY_ORDERED_TRANSFER_CONVERTER;
                    break;
                }
                result = USER_AND_GROUP_PROGRESS_CONVERTER;
                break;
            }
            default: {
                throw new RuntimeException("No progress convertor defined for container type: ");
            }
        }
        return result;
    }

    private static boolean isAttachmentUploadOnly(ConfluenceSpaceContainer container) {
        return container.getSelections().size() == 1 && container.getSelections().contains((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS);
    }
}

