/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.app.Experimental;
import java.util.Objects;
import java.util.Optional;

@Experimental(value="This is an experimental API to support App Data Preload feature, this is not yet ready for production use.")
public class PreloadedAppDataDetails {
    private final String id;
    private final String key;
    private final String failedReason;
    private final String dataPreloadTransferId;
    private final Long expireAtInEpochMillis;

    public PreloadedAppDataDetails(String id, String key, String failedReason, String dataPreloadTransferId, Long expireAtInEpochMillis) {
        Objects.requireNonNull(id, "id cannot be null");
        if (key == null && failedReason == null) {
            throw new IllegalArgumentException("Either key or failedReason must be provided");
        }
        this.id = id;
        this.key = key;
        this.failedReason = failedReason;
        this.dataPreloadTransferId = dataPreloadTransferId;
        this.expireAtInEpochMillis = expireAtInEpochMillis;
    }

    public String getId() {
        return this.id;
    }

    public String getDataPreloadTransferId() {
        return this.dataPreloadTransferId;
    }

    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    public Optional<String> getFailedReason() {
        return Optional.ofNullable(this.failedReason);
    }

    public Optional<Long> getExpiryTime() {
        return Optional.ofNullable(this.expireAtInEpochMillis);
    }

    public boolean isUploaded() {
        return this.key != null && this.failedReason == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreloadedAppDataDetails that = (PreloadedAppDataDetails)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.key, that.key) && Objects.equals(this.failedReason, that.failedReason) && Objects.equals(this.dataPreloadTransferId, that.dataPreloadTransferId) && Objects.equals(this.expireAtInEpochMillis, that.expireAtInEpochMillis);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.failedReason, this.dataPreloadTransferId, this.expireAtInEpochMillis);
    }

    public String toString() {
        return "PreloadedAppDataDetails{id=" + this.id + ", key='" + this.key + '\'' + ", failedReason='" + this.failedReason + '\'' + ", dataPreloadTransferId='" + this.dataPreloadTransferId + '\'' + ", expireAtInEpochMillis=" + this.expireAtInEpochMillis + '}';
    }
}

