/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.store.guardrails.AssessmentApplinkService;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.SeparateFileQuery;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkAppType;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkDto;
import com.atlassian.migration.agent.store.guardrails.model.ApplinkTargetEnv;
import com.atlassian.migration.agent.store.guardrails.queries.AbstractSingletonQuery;
import com.atlassian.migration.agent.store.guardrails.results.JsonResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;

public class ApplinkQuery
extends AbstractSingletonQuery
implements SeparateFileQuery {
    private final AssessmentApplinkService assessmentApplinkService;
    private static final List<ApplinkDto> EXAMPLE = ImmutableList.of((Object)ApplinkDto.builder().applinkId("d44e7289-a252-455c-a3db-2962486df147").appRpcUrl("https://jira_dc.com").appType(ApplinkAppType.JIRA).targetEnv(ApplinkTargetEnv.ON_PREMISE).version("9.12.13").build(), (Object)ApplinkDto.builder().applinkId("277bb612-9f3d-4628-921a-8cf081bf65f8").appRpcUrl("https://jira_cloud.com").appType(ApplinkAppType.JIRA).targetEnv(ApplinkTargetEnv.CLOUD).version(null).build(), (Object)ApplinkDto.builder().applinkId("b977b67b-7881-4f44-abe4-64ccd8476bd6").appRpcUrl("https://confluence_dc.com").appType(ApplinkAppType.CONFLUENCE).targetEnv(ApplinkTargetEnv.ON_PREMISE).version("8.9.6").build(), (Object)ApplinkDto.builder().applinkId("d59d7ff2-8fde-49fa-bebc-6defaeeabe51").appRpcUrl("https://bitbucket.com").appType(ApplinkAppType.BITBUCKET).targetEnv(ApplinkTargetEnv.CLOUD).version(null).build(), (Object)ApplinkDto.builder().applinkId("27bf7a08-6d88-4acf-a39b-8e3ccb7855d7").appRpcUrl("https://stash.com").appType(ApplinkAppType.STASH).targetEnv(ApplinkTargetEnv.ON_PREMISE).version(null).build(), (Object)ApplinkDto.builder().applinkId("a6c85263-c3fa-4ca3-b509-3fbdff74a0b8").appRpcUrl("https://crowd.com").appType(ApplinkAppType.CROWD).targetEnv(ApplinkTargetEnv.NO_CONNECTION).version(null).build());

    public ApplinkQuery(AssessmentApplinkService assessmentApplinkService) {
        super(QueryIds.APP_LINKS, new JsonResult(EXAMPLE));
        this.assessmentApplinkService = assessmentApplinkService;
    }

    @Override
    protected JsonResult execute() {
        return new JsonResult(this.assessmentApplinkService.getApplinks());
    }

    @Override
    public void addToZip(QueryIds id, String date, String serverId, String assessmentStartDate, String instanceTimezone, String response, ZipBuilder zipBuilder) throws IOException {
        ImmutableMap data = ImmutableMap.of((Object)"serverId", (Object)serverId, (Object)"assessmentStartingDate", (Object)assessmentStartDate, (Object)"instanceTimezone", (Object)instanceTimezone, (Object)"applinks", (Object)new Gson().fromJson(response, new TypeToken<List<ApplinkDto>>(){}.getType()));
        zipBuilder.addJson(data, "application-links-" + date + ".jsonl", null);
    }
}

