/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.guardrails.GuardrailsTupleElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public final class GuardrailsUtil {
    private static final Logger log = ContextLoggerFactory.getLogger(GuardrailsUtil.class);
    private static final String[] PERCENTILES = new String[]{"P25", "P50", "P75", "P90", "P99"};
    private static final DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    private GuardrailsUtil() {
        throw new IllegalStateException("Utility Class");
    }

    public static String formatLong(long l) {
        return String.valueOf(l);
    }

    public static String formatDecimal(BigDecimal d) {
        return df.format(d);
    }

    public static String formatTupleListToJson(List<Tuple> tuples) {
        if (CollectionUtils.isEmpty(tuples)) {
            return "[]";
        }
        return "[" + tuples.stream().map(GuardrailsUtil::formatTupleToJson).collect(Collectors.joining(",")) + "]";
    }

    public static String formatTupleToJson(Tuple t) {
        StringBuilder formattedData = new StringBuilder("{");
        for (TupleElement e : t.getElements()) {
            Object o;
            Object object = o = t.get(e) != null && t.get(e).getClass().equals(BigDecimal.class) ? GuardrailsUtil.formatDecimal((BigDecimal)t.get(e)) : t.get(e);
            if (o instanceof List) {
                formattedData.append("\"").append(e.getAlias().toLowerCase()).append("\": ").append(GuardrailsUtil.formatTupleListToJson((List)o)).append(", ");
                continue;
            }
            formattedData.append("\"").append(e.getAlias().toLowerCase()).append("\": \"").append(o).append("\", ");
        }
        return formattedData.substring(0, formattedData.length() - 2) + "}";
    }

    public static Tuple getTuple(Map<String, Object> values) {
        return GuardrailsUtil.getTuple(values.entrySet().stream().map(e -> new GuardrailsTupleElement((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
    }

    public static Tuple getTuple(GuardrailsTupleElement<?> ... elementsArray) {
        return GuardrailsUtil.getTuple(Arrays.asList(elementsArray));
    }

    public static Tuple getTuple(final List<GuardrailsTupleElement<?>> elementsList) {
        return new Tuple(){
            private final List<TupleElement<?>> elements;
            private final Map<String, Object> map;
            {
                this.elements = ImmutableList.copyOf((Collection)elementsList);
                this.map = ImmutableMap.copyOf(elementsList.stream().filter(element -> element.getValue() != null).collect(Collectors.toMap(GuardrailsTupleElement::getAlias, GuardrailsTupleElement::getValue)));
            }

            public <X> X get(TupleElement<X> tupleElement) {
                return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
            }

            public <X> X get(String alias, Class<X> type) {
                return type.cast(this.map.get(alias));
            }

            public Object get(String alias) {
                return this.map.get(alias);
            }

            public <X> X get(int i, Class<X> type) {
                TupleElement<?> element = this.elements.get(i);
                return this.get(element.getAlias(), type);
            }

            public Object get(int i) {
                TupleElement<?> element = this.elements.get(i);
                return this.get(element.getAlias());
            }

            public Object[] toArray() {
                Object[] array = new Object[this.elements.size()];
                for (int i = 0; i < this.elements.size(); ++i) {
                    array[i] = this.get(i);
                }
                return array;
            }

            public List<TupleElement<?>> getElements() {
                return this.elements;
            }
        };
    }

    public static int getMacrosCount(String stringVal) {
        int num = 0;
        try {
            num = Optional.ofNullable(stringVal).map(val -> val.split("-")).filter(vals -> ((String[])vals).length >= 2).map(vals -> Integer.parseInt(vals[1])).orElse(0);
        }
        catch (NumberFormatException e) {
            log.debug("Failed to parse integer value when getting macros count", (Throwable)e);
        }
        return num;
    }

    public static List<Tuple> getTopK(List<Tuple> results, int k) {
        if (results == null || results.isEmpty()) {
            return new ArrayList<Tuple>();
        }
        return results.size() <= k ? results : new ArrayList(results.subList(0, k));
    }

    public static List<GuardrailsTupleElement<Integer>> getDistributions(List<Tuple> queryResult) {
        if (queryResult == null || queryResult.isEmpty()) {
            return new ArrayList<GuardrailsTupleElement<Integer>>();
        }
        int size = queryResult.size();
        ArrayList<GuardrailsTupleElement<Integer>> distributions = new ArrayList<GuardrailsTupleElement<Integer>>();
        for (String per : PERCENTILES) {
            int idx = (int)Math.ceil((1.0 - (double)Integer.parseInt(per.substring(1)) / 100.0) * (double)size);
            Integer value = (Integer)queryResult.get(idx - 1).get(1, Integer.class);
            distributions.add(new GuardrailsTupleElement<Integer>(per, value, Integer.class));
        }
        return distributions;
    }

    public static GuardrailsTupleElement<Integer> getAverage(List<Tuple> results) {
        int ave = 0;
        if (results != null) {
            ave = (int)Math.ceil(results.stream().mapToInt(tuple -> (Integer)tuple.get(1, Integer.class)).average().orElse(0.0));
        }
        return new GuardrailsTupleElement<Integer>("mean", ave, Integer.class);
    }

    public static GuardrailsTupleElement<Integer> getMax(List<Tuple> results) {
        int max = 0;
        if (results != null && !results.isEmpty()) {
            max = (Integer)results.get(0).get(1, Integer.class);
        }
        return new GuardrailsTupleElement<Integer>("max", max, Integer.class);
    }

    public static String formatPerPageDistributionResult(List<Tuple> queryResult, int k) {
        ArrayList res = new ArrayList(Arrays.asList(GuardrailsUtil.getMax(queryResult), GuardrailsUtil.getAverage(queryResult)));
        res.addAll(GuardrailsUtil.getDistributions(queryResult));
        res.add(new GuardrailsTupleElement<List<Tuple>>("values", GuardrailsUtil.getTopK(queryResult, k)));
        return GuardrailsUtil.formatTupleListToJson(Collections.singletonList(GuardrailsUtil.getTuple(res)));
    }

    public static List<Tuple> formatResult(List<Tuple> tuples) {
        ArrayList<Tuple> formattedTuples = new ArrayList<Tuple>();
        for (Tuple t : tuples) {
            int size = t.getElements().size();
            ArrayList elements = new ArrayList();
            elements.add(new GuardrailsTupleElement<Long>(((TupleElement)t.getElements().get(0)).getAlias(), ((Number)t.get(0, Number.class)).longValue(), Long.class));
            for (int i = 1; i < size; ++i) {
                elements.add(new GuardrailsTupleElement<Integer>(((TupleElement)t.getElements().get(i)).getAlias(), ((Number)t.get(i, Number.class)).intValue(), Integer.class));
            }
            formattedTuples.add(GuardrailsUtil.getTuple(elements));
        }
        return formattedTuples;
    }

    public static String toSqlListString(List<Tuple> list) {
        return "(" + list.stream().map(t -> String.valueOf(((Number)t.get(0, Number.class)).longValue())).collect(Collectors.joining(",")) + ")";
    }

    public static <T extends Comparable<T>> List<Tuple> sorted(List<Tuple> tuples, Comparator<Tuple> comparator) {
        if (tuples == null) {
            return Collections.emptyList();
        }
        return tuples.stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <T extends Comparable<T>> Comparator<Tuple> tupleComparator(int index, Class<T> cls) {
        return Comparator.comparing(tuple -> (Comparable)tuple.get(index, cls));
    }
}

