/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.entity.InstanceAnalysisControl;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlService;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlTypes;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJob;
import com.atlassian.migration.agent.service.guardrails.external.ExternalJobsService;
import com.atlassian.migration.agent.service.guardrails.usage.AccessLogProcessingJobRunner;
import com.atlassian.migration.agent.store.guardrails.AssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAnalysisControlStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AssessmentJobProgressService {
    private static final Logger log = ContextLoggerFactory.getLogger(AssessmentJobProgressService.class);
    private static final String COLLECTION_BROWSER_METRICS = "Collecting browser metrics";
    private final InstanceAnalysisControlStore instanceAnalysisControlStore;
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    private final MigrationDarkFeaturesManager featuresManager;
    private static final String SERVER_NODE = "serverNode";
    private static final int TIME_IN_MINUTES = 60;
    private final InstanceAssessmentService instanceAssessmentService;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final AccessLogProcessingJobRunner accessLogProcessingJobRunner;
    private final ExternalJobsService externalJobsService;

    public AssessmentJobProgressService(InstanceAnalysisControlStore instanceAnalysisControlStore, InstanceAnalysisControlService instanceAnalysisControlService, MigrationDarkFeaturesManager featuresManager, GuardrailsResponseGroupStore guardrailsResponseGroupStore, InstanceAssessmentService instanceAssessmentService, AccessLogProcessingJobRunner accessLogProcessingJobRunner, ExternalJobsService externalJobsService) {
        this.instanceAnalysisControlStore = instanceAnalysisControlStore;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.featuresManager = featuresManager;
        this.instanceAssessmentService = instanceAssessmentService;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.accessLogProcessingJobRunner = accessLogProcessingJobRunner;
        this.externalJobsService = externalJobsService;
    }

    public AssessmentStatus processJobProgress() {
        AssessmentStatus assessmentStatus = this.getAssessmentStatus();
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.IN_PROGRESS) {
            return assessmentStatus;
        }
        List<ExternalJob> externalJobs = this.externalJobsService.getExternalJobs();
        Optional<ExternalJob> externalJobInProgress = this.filter(externalJobs, ExternalJob.ExternalJobStatus.IN_PROGRESS).findFirst();
        if (externalJobInProgress.isPresent()) {
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.inProgressAssessmentOld(externalJobInProgress.get().name());
            }
            return AssessmentStatus.inProgressAssessment("Collecting " + externalJobInProgress.get().name());
        }
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.COMPLETE && !externalJobs.isEmpty()) {
            Optional<ExternalJob> errorJob = this.filter(externalJobs, ExternalJob.ExternalJobStatus.ERROR).findAny();
            if (errorJob.isPresent()) {
                if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                    return AssessmentStatus.failedAssessment();
                }
                return AssessmentStatus.failedAssessment(errorJob.get().getCompletedTimestamp());
            }
            Instant completedTimestamp = Stream.concat(this.filter(externalJobs, ExternalJob.ExternalJobStatus.COMPLETED).map(ExternalJob::getCompletedTimestamp), Stream.of(assessmentStatus.getFinishDate())).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.completedAssessmentOld(completedTimestamp);
            }
            return AssessmentStatus.completedAssessment(completedTimestamp);
        }
        return assessmentStatus;
    }

    private Stream<ExternalJob> filter(List<ExternalJob> jobs, ExternalJob.ExternalJobStatus status) {
        return jobs.stream().filter(job -> job.getStatus() == status);
    }

    @NotNull
    private AssessmentStatus getAssessmentStatus() {
        Optional<InstanceAnalysisControl> instanceAnalysisControl;
        if (this.featuresManager.isBrowserMetricsEnabled() && (instanceAnalysisControl = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent()) {
            return this.getBrowserMetricsProgress(instanceAnalysisControl.get());
        }
        Optional<GuardrailsResponseGroup> lastJob = this.guardrailsResponseGroupStore.findLast();
        if (!lastJob.isPresent()) {
            return AssessmentStatus.notStartedAssessment();
        }
        GuardrailsResponseGroup guardrailsResponseGroup = lastJob.get();
        String jobId = guardrailsResponseGroup.getJobId();
        try {
            Set<JobDetails> activeJobsDetails = this.instanceAssessmentService.getActiveJobs();
            Set activeJobs = activeJobsDetails.stream().map(JobDetails::getJobId).map(Object::toString).collect(Collectors.toSet());
            log.info("Current jobId is:{} and number of running jobs are :{}", (Object)jobId, (Object)activeJobs.size());
            if (activeJobs.contains(jobId)) {
                long progress = this.instanceAssessmentService.getJobProgress(jobId);
                if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                    return AssessmentStatus.inProgressAssessmentOld(progress + "% COMPLETE");
                }
                return AssessmentStatus.inProgressAssessment("Collecting guardrails, " + progress + "% COMPLETE");
            }
            if (guardrailsResponseGroup.isCanceled()) {
                return AssessmentStatus.cancelAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
            }
            log.info("Job completed for jobId:{}", (Object)jobId);
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.completedAssessmentOld(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
            }
            return AssessmentStatus.completedAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
        }
        catch (Exception e) {
            log.error("Failed to get progress for jobId:{} with exception:{}", (Object)jobId, (Object)e);
            return AssessmentStatus.failedAssessment();
        }
    }

    private AssessmentStatus getBrowserMetricsProgress(InstanceAnalysisControl instanceAnalysisControl) {
        if (this.instanceAnalysisControlStore.isFinished(instanceAnalysisControl)) {
            if (!this.accessLogProcessingJobRunner.isFinished()) {
                if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                    return AssessmentStatus.inProgressAssessmentOld("0 h 1 m remaining");
                }
                return AssessmentStatus.inProgressAssessment(COLLECTION_BROWSER_METRICS, 1000L);
            }
            Long endTimestamp = instanceAnalysisControl.getEndTimestamp();
            Timestamp tms = new Timestamp(endTimestamp);
            Date completedDate = new Date(tms.getTime());
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.completedAssessmentOld(completedDate.toInstant());
            }
            if (instanceAnalysisControl.isCanceled()) {
                return AssessmentStatus.cancelAssessment(completedDate.toInstant());
            }
            return AssessmentStatus.completedAssessment(completedDate.toInstant());
        }
        Duration remainingDuration = this.instanceAnalysisControlService.calculateRemainingDuration(instanceAnalysisControl);
        if (remainingDuration.isZero()) {
            this.finishAssessmentCollection();
        }
        if (this.featuresManager.isNewAssessmentStatusDisabled()) {
            return AssessmentStatus.inProgressAssessmentOld(remainingDuration.toHours() + " h " + remainingDuration.toMinutes() % 60L + " m remaining");
        }
        return AssessmentStatus.inProgressAssessment(COLLECTION_BROWSER_METRICS, remainingDuration.toMillis());
    }

    private void finishAssessmentCollection() {
        log.info("Stopping Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.finishAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentStatus scheduleInstanceAssessment() throws SchedulerServiceException {
        Set<JobDetails> activeJobs;
        Optional<InstanceAnalysisControl> currentInstanceAnalysis;
        if (this.featuresManager.isBrowserMetricsEnabled()) {
            this.accessLogProcessingJobRunner.startAssessment();
        }
        if ((currentInstanceAnalysis = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent() && !this.instanceAnalysisControlStore.isFinished(currentInstanceAnalysis.get())) {
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.inProgressAssessmentOld(this.processJobProgress().getDescription());
            }
            return AssessmentStatus.inProgressAssessment(this.processJobProgress().getDescription());
        }
        if (this.featuresManager.isBrowserMetricsEnabled()) {
            this.instanceAnalysisControlService.startAssessmentCollection();
        }
        if (!(activeJobs = this.instanceAssessmentService.getActiveJobs()).isEmpty()) {
            JobDetails job = activeJobs.iterator().next();
            String jobId = job.getJobId().toString();
            Map map = job.getParameters();
            String nodeId = (String)map.get(SERVER_NODE);
            log.info("Job already running for nodeId: {} and jobId:{}", (Object)nodeId, (Object)jobId);
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.inProgressAssessmentOld(this.processJobProgress().getDescription());
            }
            return AssessmentStatus.inProgressAssessment(this.processJobProgress().getDescription());
        }
        log.info("There are no active jobs");
        this.instanceAssessmentService.scheduleJob();
        this.externalJobsService.startExternalJobs();
        return AssessmentStatus.newAssessment();
    }

    public AssessmentStatus cancelAssessmentCollection() {
        InstanceAssessmentStatus status = this.processJobProgress().getStatus();
        if (status.equals((Object)InstanceAssessmentStatus.IN_PROGRESS)) {
            this.cancelGuardrailsCollection();
            this.cancelExternalJobs();
            this.cancelBrowserMetricsCollection();
            return AssessmentStatus.cancelAssessment(Instant.now());
        }
        return AssessmentStatus.notStartedAssessment();
    }

    private void cancelExternalJobs() {
        this.externalJobsService.stopExternalJobs();
    }

    private void cancelGuardrailsCollection() {
        this.instanceAssessmentService.cancelAssessmentCollection();
    }

    private void cancelBrowserMetricsCollection() {
        log.info("Cancelling Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.cancelAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }
}

