/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.network;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.migration.agent.service.check.network.NetworkCheckResult;
import com.atlassian.migration.agent.service.check.network.NetworkHealthChecker;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class NetworkHealthMapper
extends AbstractMapper {
    public static final String RUNNING_DESCRIPTION = "Checking if all the required URLs have been granted network access";
    public static final String EXECUTION_ERROR_DESCRIPTION = "We couldn't check if all the required URLs have been granted network access";
    public static final String WARNING_ERROR_DESCRIPTION = "Network access is unavailable for some URLs";
    public static final String SUCCESS_DESCRIPTION = "Network access is granted to all URLs";

    protected void inject(CheckResultDto dto, CheckResult checkResult) {
        switch (dto.getStatus()) {
            case RUNNING: {
                dto.setDescription(RUNNING_DESCRIPTION);
                break;
            }
            case EXECUTION_ERROR: {
                dto.setDescription(EXECUTION_ERROR_DESCRIPTION);
                break;
            }
            case WARNING: 
            case ERROR: {
                dto.setDescription(WARNING_ERROR_DESCRIPTION);
                List violations = NetworkHealthChecker.retrieveFailedNetworkHealthUrls(checkResult.details).stream().map(NetworkCheckResult::getFailedDomains).flatMap(Collection::stream).collect(Collectors.toList());
                CheckDetailsDto details = new CheckDetailsDto();
                details.setListOfOccurrences(violations);
                dto.setDetails(details);
                dto.setNumberOfOccurrences(Integer.valueOf(violations.size()));
                break;
            }
            case SUCCESS: {
                dto.setDescription(SUCCESS_DESCRIPTION);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
    }
}

